/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractScanningLoader;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanningLongSumLoader
extends AbstractScanningLoader<Long> {
    private final AttributeSpec<Long> myDependency;

    public ScanningLongSumLoader(@NotNull AttributeSpec<Long> spec, AttributeSpec<Long> dependency) {
        super(spec);
        this.myDependency = dependency;
    }

    @Override
    @Nullable
    public Set<AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myDependency);
    }

    @Override
    @Nullable
    protected Long loadValueForPassingRow(@Nullable Long precedingValue, ScanningAttributeContext context) {
        return Stream.of(precedingValue, context.getDependencyValue(this.myDependency)).filter(Objects::nonNull).reduce(Long::sum).orElse(null);
    }
}

