/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.UpToDateLoadedValue;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface LoadedValue<T> {
    @NotNull
    public AttributeValue<T> getValue();

    public boolean isOutdated();

    public static <T> LoadedValue<T> of(@NotNull AttributeValue<T> attributeValue) {
        if (attributeValue == null) {
            throw new NullPointerException();
        }
        return new UpToDateLoadedValue<T>(attributeValue);
    }

    public static <T> LoadedValue<T> of(@Nullable T value) {
        return new UpToDateLoadedValue<T>(AttributeValue.ofNullable(value));
    }
}

