package com.almworks.jira.structure.api.export.excel;

import com.atlassian.annotations.PublicApi;

/**
 * {@code ExcelStyle} represents the default cell styles used by Structure's Excel export.
 */
@PublicApi
public enum ExcelStyle {
  /**
   * The default style. Used for data cells if no other style is specified.
   */
  DEFAULT,

  /**
   * Left-aligned header style. Used for header cells if no other style was specified.
   */
  HEADER_LEFT_ALIGNED,

  /**
   * Right-aligned header style. Use it for numeric, date, and duration column header cells.
   */
  HEADER_RIGHT_ALIGNED,

  /**
   * Date style. Use it as the default cell style for date columns or for individual date cells.
   */
  DATE,

  /**
   * Date and time style. Use it as the default cell style for date and time columns or for individual date and time
   * cells.
   */
  DATETIME,

  /**
   * Duration style. Use it as the default cell style for duration columns or for individual duration cells.
   */
  DURATION,

  /**
   * Percentage style. Use it as the default style for percentage columns or for individual percentage cells.
   */
  PERCENTAGE,

  /**
   * Hyperlink style. Use it as the default style for hyperlink columns or for individual hyperlink cells.
   */
  HYPERLINK,

  /**
   * Hyperlink style with no underlining. Use it instead of {@code HYPERLINK} when you don't want the decoration.
   */
  HYPERLINK_UNDECORATED
}
