package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.*;
import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Set;
import java.util.function.*;

public class BaseItemAttributeLoader<T> extends BaseAttributeLoader<T> implements ItemAttributeLoader<T> {
  @Nullable
  private final Predicate<String> myItemTypeSupportedPredicate;

  @NotNull
  private final BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> myAttributeFunction;

  @Nullable
  private final BiConsumer<Collection<ItemIdentity>, AttributeContext> myPreloadFunction;

  public BaseItemAttributeLoader(@NotNull AttributeSpec<T> attributeSpec,
    @Nullable Set<AttributeSpec<?>> dependencies,
    @Nullable Set<AttributeContextDependency> contextDependencies,
    @Nullable AttributeCachingStrategy cachingStrategy, @Nullable TrailItemSet globalTrail,
    @Nullable Predicate<String> itemTypeSupportedPredicate,
    @NotNull BiFunction<ItemIdentity, ItemAttributeContext, AttributeValue<T>> attributeFunction,
    @Nullable BiConsumer<Collection<ItemIdentity>, AttributeContext> preloadFunction)
  {
    super(attributeSpec, dependencies, contextDependencies, cachingStrategy, globalTrail);
    myItemTypeSupportedPredicate = itemTypeSupportedPredicate;
    myAttributeFunction = attributeFunction;
    myPreloadFunction = preloadFunction;
  }

  @Override
  public boolean isItemTypeSupported(@NotNull String itemType) {
    return myItemTypeSupportedPredicate == null || myItemTypeSupportedPredicate.test(itemType);
  }

  @Nullable
  @Override
  public AttributeValue<T> loadValue(@NotNull ItemIdentity itemId, @NotNull ItemAttributeContext context) {
    return myAttributeFunction.apply(itemId, context);
  }

  @Override
  public void preload(@NotNull Collection<ItemIdentity> itemIds, @NotNull AttributeContext context) {
    if (myPreloadFunction != null) {
      myPreloadFunction.accept(itemIds, context);
    }
  }
}
