/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.structure.history;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.structure.history.HistoryEntry;

public class ForestVersion {
    public final Forest fullForest;
    public final HistoryEntry entry;
    public final int weight;

    public ForestVersion(Forest fullForest, HistoryEntry entry) {
        this.fullForest = fullForest;
        this.entry = entry;
        this.weight = ForestVersion.weigh(fullForest, entry);
    }

    private static int weigh(Forest fullForest, HistoryEntry entry) {
        int weight = 128 + ForestVersion.sizeOf(fullForest);
        for (HistoryEntry.Change change : entry.getChanges()) {
            weight += 80 + ForestVersion.sizeOf(change.getForest()) + ForestVersion.sizeOf(change.getPathFrom()) + ForestVersion.sizeOf(change.getAfterFrom()) + ForestVersion.sizeOf(change.getPathTo()) + ForestVersion.sizeOf(change.getAfterTo());
        }
        return weight;
    }

    private static int sizeOf(Forest forest) {
        return forest == null || forest.isEmpty() ? 0 : 128 + forest.size() * 12;
    }

    private static int sizeOf(LongList list) {
        return list == null || list.isEmpty() ? 0 : 64 + list.size() * 8;
    }
}

