/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.generator.util;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.attribute.AttributeUpdateChecker;
import com.almworks.jira.structure.api.generator.UpdateChecker;
import com.almworks.jira.structure.api.row.StructureRow;

public class RecordingAttributeUpdateChecker
implements UpdateChecker {
    private final AttributeUpdateChecker myAttributeChecker;
    private final WritableLongList myRecordedRows = new LongArray();
    private volatile boolean myRecording = true;

    public RecordingAttributeUpdateChecker(AttributeUpdateChecker attributeChecker) {
        this.myAttributeChecker = attributeChecker;
    }

    public void record(StructureRow row) {
        if (row != null && row.getRowId() != 0L) {
            this.record(row.getRowId());
        }
    }

    public void record(long rowId) {
        if (!this.myRecording) {
            throw new IllegalStateException("mutating " + this + " after hasUpdate() was called");
        }
        this.myRecordedRows.add(rowId);
    }

    @Override
    public boolean hasUpdate() {
        this.myRecording = false;
        return this.myAttributeChecker.hasUpdate((LongList)this.myRecordedRows);
    }
}

