package com.almworks.jira.structure.api.forest.raw;

import com.almworks.jira.structure.api.util.IterationControl;

/**
 * {@code ForestIterationControl} is an auxiliary object passed to some forest iteration methods for
 * control of the iteration over a forest.
 */
public interface ForestIterationControl extends IterationControl {
  /**
   * @return the forest being iterated
   */
  Forest getForest();

  /**
   * @return current index of the iteration
   */
  int getIndex();

  /**
   * @return current depth in the forest
   */
  int getDepth();
}
