package com.almworks.jira.structure.api.auth;

import com.almworks.jira.structure.api.util.CallableE;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AuthContext {
  AuthContext CURRENT = new AuthContext() {
    @Nullable
    @Override
    public ApplicationUser getUser() {
      return StructureAuth.getUser();
    }

    @Override
    public boolean isSecurityOverridden() {
      return StructureAuth.isSecurityOverridden();
    }

    @Override
    public <R, E extends Exception> R sudo(@NotNull CallableE<R, E> f) throws E {
      return f.call();
    }
  };

  @Nullable
  ApplicationUser getUser();

  boolean isSecurityOverridden();

  <R, E extends Exception> R sudo(@NotNull CallableE<R, E> f) throws E;


  class Custom implements AuthContext {
    @Nullable
    private final ApplicationUser myUser;

    private final boolean mySecurityOverridden;

    public Custom(@Nullable ApplicationUser user, boolean securityOverridden) {
      myUser = user;
      mySecurityOverridden = securityOverridden;
    }

    @Nullable
    @Override
    public final ApplicationUser getUser() {
      return myUser;
    }

    @Override
    public final boolean isSecurityOverridden() {
      return mySecurityOverridden;
    }

    @Override
    public final <R, E extends Exception> R sudo(@NotNull CallableE<R, E> f) throws E {
      return StructureAuth.sudo(myUser, mySecurityOverridden, f);
    }
  }
}
