/**
 * <p>This package provides Attribute API. Attributes is a concept added by Structure platform for universal access
 * to item data.</p>
 *
 * <p>An <strong>attribute</strong> is something that can be calculated or retrieved for a structure row or an item.
 * In Structure-based apps, most item data is retrieved not by going to a corresponding underlying service (like IssueService),
 * but through attributes. Attributes also provide a way to show aggregate or derived values.</p>
 *
 * <p>An attribute is identified by {@link com.almworks.jira.structure.api.attribute.AttributeSpec}. To calculate
 * the values, client code passes {@link com.almworks.jira.structure.api.forest.ForestSpec}, row IDs and
 * attribute specifications to {@link com.almworks.jira.structure.api.attribute.StructureAttributeService} and
 * receives a matrix with values as a result.</p>
 *
 * <p>Attributes are extensible. The specific implementation of an attribute is provided by Structure itself or by
 * other add-ons. It is therefore important to notice that if an add-on is installed or uninstalled, the implementation
 * of some attributes may change.</p>
 *
 * <p>For the SPI, see {@link com.almworks.jira.structure.api.attribute.loader} package.</p>
 *
 * <p><strong>Note:</strong> It is important to differentiate attributes from columns. A column in Structure widget displays some
 * HTML to the user. It usually requires one or more attributes to be loaded, it then takes attribute values
 * and displays them somehow (sometimes as-is, sometimes not &mdash; for example, <em>Icons</em> column can
 * display concatenated icons, loaded through several attributes.</p>
 */
package com.almworks.jira.structure.api.attribute;