/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SourceOfTruth {
    JIRA("jira"),
    STRUCTURE("structure");

    private final String myCode;

    private SourceOfTruth(String code) {
        this.myCode = code;
    }

    @NotNull
    public static SourceOfTruth fromCode(@Nullable String code) {
        SourceOfTruth value = SourceOfTruth.parse(code);
        if (value == null) {
            throw new IllegalArgumentException("Unknown code for SourceOfTruth " + code);
        }
        return value;
    }

    @Nullable
    private static SourceOfTruth parse(@Nullable String code) {
        if (code == null) {
            return null;
        }
        switch (code.toLowerCase(Locale.ENGLISH)) {
            case "jira": {
                return JIRA;
            }
            case "structure": {
                return STRUCTURE;
            }
        }
        return null;
    }

    public String getCode() {
        return this.myCode;
    }
}

