/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.event;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.event.JiraChangeEvent;
import com.almworks.jira.structure.api.event.JiraChangeType;
import org.jetbrains.annotations.NotNull;

public class LinkChangeEvent
extends JiraChangeEvent {
    private final long myLinkTypeId;
    private final long mySourceId;
    private final long myDestinationId;

    public LinkChangeEvent(@NotNull JiraChangeType changeType, long linkTypeId, long sourceId, long destinationId) {
        super(changeType);
        this.myLinkTypeId = linkTypeId;
        this.mySourceId = sourceId;
        this.myDestinationId = destinationId;
    }

    public long getLinkTypeId() {
        return this.myLinkTypeId;
    }

    public long getSourceId() {
        return this.mySourceId;
    }

    public long getDestinationId() {
        return this.myDestinationId;
    }

    @Override
    public LongList getAffectedIssuesSorted() {
        return this.mySourceId < this.myDestinationId ? LongArray.create((long[])new long[]{this.mySourceId, this.myDestinationId}) : LongArray.create((long[])new long[]{this.myDestinationId, this.mySourceId});
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getChangeType()) + "(" + this.myLinkTypeId + ':' + this.mySourceId + "=>" + this.myDestinationId + ')';
    }

    public static long getSourceId(JiraChangeEvent event) {
        if (event instanceof LinkChangeEvent) {
            return ((LinkChangeEvent)event).getSourceId();
        }
        return 0L;
    }

    public static long getDestinationId(JiraChangeEvent event) {
        if (event instanceof LinkChangeEvent) {
            return ((LinkChangeEvent)event).getDestinationId();
        }
        return 0L;
    }

    public static long getLinkTypeId(JiraChangeEvent event) {
        if (event instanceof LinkChangeEvent) {
            return ((LinkChangeEvent)event).getLinkTypeId();
        }
        return 0L;
    }
}

