package com.almworks.jira.structure.api.rest;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Map;

@XmlRootElement
public final class RestValueResponse {
  @XmlElement
  public List<ForestRowValueResponse> responses;

  @XmlElement
  public Map itemTypes;

  @XmlElement
  public RestVersion itemsVersion;

  @XmlRootElement
  public static class ForestRowValueResponse {
    @XmlElement
    public RestForestSpec forestSpec;

    @XmlElement
    public List<Long> rows;

    @XmlElement
    public List<AttributeResponseData> data;

    @XmlElement
    public RestVersion forestVersion;

    @XmlElement
    public List<Long> inaccessibleRows;
  }

  @XmlRootElement
  public static class AttributeResponseData {
    @XmlElement
    public RestAttributeSpec attribute;

    @XmlElement
    public List<Object> values; // given in the same order as rowIds

    @XmlElement
    public String trailMode; // list of ForestProcessingTypes, separated by ","

    @XmlElement
    public List<String> trails; // given in the same order as rowIds, each string is a list of itemIds, serialized by ItemSerializer
  }
}
