package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Function;

public class BaseDerivedAttributeLoader<T> extends BaseAttributeLoader<T> implements DerivedAttributeLoader<T> {
  @NotNull
  private final Function<DerivedAttributeContext, AttributeValue<T>> myLoadingFunction;

  public BaseDerivedAttributeLoader(@NotNull AttributeSpec<T> attributeSpec,
    @Nullable Set<AttributeSpec<?>> dependencies,
    @Nullable Set<AttributeContextDependency> contextDependencies,
    @Nullable AttributeCachingStrategy cachingStrategy, @Nullable TrailItemSet globalTrail,
    @NotNull Function<DerivedAttributeContext, AttributeValue<T>> loadingFunction)
  {
    super(attributeSpec, dependencies, contextDependencies, cachingStrategy, globalTrail);
    myLoadingFunction = loadingFunction;
  }

  @Nullable
  @Override
  public AttributeValue<T> loadValue(@NotNull DerivedAttributeContext context) {
    return myLoadingFunction.apply(context);
  }
}
