/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.sync.StructureSynchronizer;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public interface Structure2xBackwardCompatibleSynchronizer
extends StructureSynchronizer {
    @Nullable
    public Map<String, Object> migrateParameters(@NotNull byte[] var1) throws StructureException;

    public static class SyncMigrationUtil {
        private static final Logger log = LoggerFactory.getLogger(SyncMigrationUtil.class);

        @NotNull
        public static <P> P restoreStructure2xParameters(byte[] data, Class<P> paramsClazz) throws StructureException {
            if (data == null) {
                throw StructureErrors.INVALID_PARAMETER.withMessage("missing parameters");
            }
            try {
                JAXBContext jaxbContext = StructureUtil.createJAXBContext(paramsClazz);
                if (jaxbContext == null) {
                    log.warn("cannot create JAXB context for " + paramsClazz);
                    throw StructureErrors.INVALID_PARAMETER.withMessage("cannot migrate parameters");
                }
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Object object = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(data));
                if (object == null) {
                    throw StructureErrors.INVALID_PARAMETER.withMessage("empty parameters after migration");
                }
                if (!paramsClazz.isInstance(object)) {
                    log.warn("cannot unmarshal synchronizer parameters, unexpected class " + object.getClass());
                    throw StructureErrors.INVALID_PARAMETER.withMessage("incompatible parameters class " + object.getClass());
                }
                return paramsClazz.cast(object);
            }
            catch (JAXBException e) {
                log.error("error unmarshalling parameters", (Throwable)e);
                throw StructureErrors.INVALID_PARAMETER.causedBy(e).withMessage("cannot migrate parameters");
            }
        }
    }
}

