/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.row.ItemAccessMode;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagerBackedItemForest
implements ItemForest {
    @NotNull
    private final Forest myForest;
    @NotNull
    private final RowManager myRowManager;
    @Nullable
    private final ItemAccessMode myDefaultAccessMode;

    public ManagerBackedItemForest(@NotNull Forest forest, @NotNull RowManager rowManager) {
        this(forest, rowManager, ItemAccessMode.NORMAL_ACCESS);
    }

    public ManagerBackedItemForest(@NotNull Forest forest, @NotNull RowManager rowManager, @Nullable ItemAccessMode defaultAccessMode) {
        this.myForest = forest;
        this.myRowManager = rowManager;
        this.myDefaultAccessMode = defaultAccessMode;
    }

    @Override
    @NotNull
    public Forest getForest() {
        return this.myForest;
    }

    @Override
    @NotNull
    public StructureRow getRow(long rowId, @NotNull ItemAccessMode access) throws MissingRowException {
        return this.myRowManager.getRow(rowId, this.getAccessMode(access));
    }

    @Override
    public void scanRows(@Nullable LongIterable rows, boolean sorted, @NotNull ItemAccessMode access, @Nullable LongCollector missingCollector, @NotNull Predicate<StructureRow> iteratee) throws MissingRowException {
        this.myRowManager.scanRows(rows, sorted, this.getAccessMode(access), missingCollector, iteratee);
    }

    private ItemAccessMode getAccessMode(@NotNull ItemAccessMode access) {
        return access != ItemAccessMode.NORMAL_ACCESS ? access : this.myDefaultAccessMode;
    }

    public String toString() {
        return this.myForest.toFullString();
    }
}

