package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * This is a factory for {@link ActionEffect}'s. The result of handler implementation should be a pair of effects in context that will be called for apply/undo the certain change.
 * Handler can do any checks result of that will not change during effects life. Other checks should be done during effects calculation.
 */
public interface ActionHandler {

  interface InserterActionHandler extends ActionHandler {
    void addFragment(@NotNull ItemForest fragment, @NotNull StructurePosition to,
      @NotNull StructureGenerator.HandlingContext context);

    void moveRow(@NotNull StructureRow row, @NotNull StructurePosition to,
      @NotNull StructureGenerator.HandlingContext context);

    void removeRow(@NotNull StructureRow row, @NotNull StructureGenerator.HandlingContext context);

    @NotNull String getAddOptionDescription();
    @NotNull String getMoveOptionDescription();
  }


  interface ExtenderActionHandler extends ActionHandler {
    void moveExtension(@NotNull StructureRow extension, @Nullable StructurePosition from,
      @Nullable StructurePosition to, @NotNull StructureGenerator.HandlingContext context);

    void reorderExtension(@NotNull StructureRow extension, @NotNull StructurePosition from,
      @NotNull StructurePosition to, @NotNull StructureGenerator.HandlingContext context);

    @NotNull String getAddOptionDescription();
    @NotNull String getMoveOptionDescription();
    @NotNull String getReorderOptionDescription();
  }


  interface GrouperActionHandler extends ActionHandler {
    void moveGroupedItem(@NotNull StructureRow item, @Nullable StructureRow from, @Nullable StructureRow to,
      @NotNull StructureGenerator.HandlingContext context);
    void reorderGroup(@NotNull StructureRow group, @NotNull StructurePosition from, @NotNull StructurePosition to,
      @NotNull StructureGenerator.HandlingContext context);
  }


  interface SorterActionHandler extends ActionHandler {
    void reorderItem(@NotNull StructureRow row, @Nullable StructurePosition from, @NotNull StructurePosition to,
      @NotNull StructureGenerator.HandlingContext context);
  }
}
