package com.almworks.jira.structure.api.error;

import com.atlassian.annotations.PublicApi;

/**
 * <p>{@code StructureProviderException} is intended to be used by the code that extends Structure via implementing
 * SPI interfaces. Where this exception is declared, Structure lets the extending code signal errors.</p>
 */
@PublicApi
public class StructureProviderException extends Exception {
  public StructureProviderException() {}

  public StructureProviderException(Throwable cause) {
    super(cause);
  }

  public StructureProviderException(String message) {
    super(message);
  }

  public StructureProviderException(String message, Throwable cause) {
    super(message, cause);
  }
}
