package com.almworks.jira.structure.api.error;

import com.atlassian.annotations.PublicApi;

/**
 * Defines categories for errors that may be reported by Structure and its extensions.
 *
 * @see StructureError
 * @see StructureErrors
 * @see StructureException
 */
@PublicApi
public enum StructureErrorCategory {
  /**
   * Default category for general errors.
   */
  GENERAL,

  /**
   * Errors in this category are caused by user input, whether immediately preceding the unsuccessful
   * action, or entered previously.
   */
  INVALID_INPUT,

  /**
   * This category contains errors that are caused by the actor not having sufficient permissions for
   * the action.
   */
  NO_PERMISSION,

  /**
   * This category contains errors that mean that the requested object is either not found, does not
   * exist anymore or the user does not have access to it.
   */
  NOT_FOUND,

  /**
   * Errors in this category mean that there was some problem with JIRA, Structure or Structure extension
   * internals. The text of the error is typically not shown to the user but reported to support.
   */
  INTERNAL
}
