/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.item.ItemIdentity;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttributeLoaderBuilder<T, S extends AttributeLoaderBuilder<T, S>> {
    protected AttributeSpec<T> myAttributeSpec;
    protected AttributeCachingStrategy myCachingStrategy;
    protected TrailItemSet myGlobalTrail;
    private Set<AttributeContextDependency> myContextDependencies;

    public S spec(AttributeSpec<T> attributeSpec) {
        this.myAttributeSpec = attributeSpec;
        return this.self();
    }

    public S contextDependencies(AttributeContextDependency ... dependencies) {
        if (dependencies != null) {
            for (AttributeContextDependency dependency : dependencies) {
                this.contextDependency(dependency);
            }
        }
        return this.self();
    }

    public S contextDependency(@Nullable AttributeContextDependency dependency) {
        if (dependency != null) {
            Set<AttributeContextDependency> contextDependencies = this.myContextDependencies;
            if (contextDependencies == null) {
                this.myContextDependencies = contextDependencies = EnumSet.noneOf(AttributeContextDependency.class);
            }
            contextDependencies.add(dependency);
        }
        return this.self();
    }

    public S noContextDependencies() {
        this.myContextDependencies = Collections.emptySet();
        return this.self();
    }

    public S cachingStrategy(AttributeCachingStrategy cachingStrategy) {
        this.myCachingStrategy = cachingStrategy;
        return this.self();
    }

    public S globalTrail(@Nullable TrailItemSet trail) {
        this.myGlobalTrail = trail == null ? this.myGlobalTrail : trail.union(this.myGlobalTrail);
        return this.self();
    }

    public S globalTrail(@Nullable ItemIdentity item) {
        return this.globalTrail(TrailItemSet.of(item));
    }

    protected S self() {
        return (S)this;
    }

    @Nullable
    protected Set<AttributeContextDependency> buildContextDependencies() {
        Set<AttributeContextDependency> contextDependencies = this.myContextDependencies;
        if (contextDependencies == null) {
            return null;
        }
        if (contextDependencies.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(contextDependencies));
    }

    @NotNull
    protected static <R> R notNull(@Nullable R parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("null " + parameterName);
        }
        return parameter;
    }

    @Nullable
    protected static <R extends Collection> R nullableCollectionOfNonNulls(@Nullable R parameter, String parameterName) {
        if (parameter == null) {
            return parameter;
        }
        int i = 0;
        for (Object value : parameter) {
            if (value == null) {
                throw new IllegalArgumentException("null " + parameterName + "[" + i + "]");
            }
            ++i;
        }
        return parameter;
    }
}

