/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntList;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractAttributeLoader;
import com.almworks.jira.structure.api.util.SpecParams;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScanningLoader<T>
extends AbstractAttributeLoader<T>
implements ScanningAttributeLoader<T> {
    private final int myBaseLevel;
    @Nullable
    private final Predicate<ScanningAttributeContext> myBaseLevelCheck;
    @Nullable
    private final IntList myLevels;
    @Nullable
    private final Predicate<ScanningAttributeContext> myLevelCheck;

    protected AbstractScanningLoader(@NotNull AttributeSpec<T> spec) {
        super(spec);
        SpecParams params = spec.getParams();
        this.myBaseLevel = Math.max(0, params.getInt("baseLevel"));
        this.myLevels = AbstractScanningLoader.getLevels(params, this.myBaseLevel);
        this.myLevelCheck = this.myLevels == null ? null : ctx -> this.myLevels.contains(ctx.getDepth());
        this.myBaseLevelCheck = this.myBaseLevel == 0 ? null : ctx -> ctx.getDepth() < this.myBaseLevel;
    }

    protected boolean isLevelSkipped(ScanningAttributeContext context) {
        return this.myLevelCheck != null && !this.myLevelCheck.test(context);
    }

    protected boolean isAboveBaseLevel(ScanningAttributeContext context) {
        return this.myBaseLevelCheck != null && this.myBaseLevelCheck.test(context);
    }

    @Nullable
    protected Integer getBaseLevel() {
        return this.myBaseLevel;
    }

    @Nullable
    protected IntList getLevelsSorted() {
        return this.myLevels;
    }

    @Override
    @Nullable
    public AttributeValue<T> loadValue(@NotNull AttributeValue<T> precedingValue, @NotNull ScanningAttributeContext context) {
        T newValue;
        if (this.isAboveBaseLevel(context)) {
            return AttributeValue.undefined();
        }
        if (this.isLevelSkipped(context)) {
            return this.carryPrecedingValueForSkippedRow(precedingValue);
        }
        if (this.isRowSkipped(precedingValue, context)) {
            return this.carryPrecedingValueForSkippedRow(precedingValue);
        }
        T value = this.getCarriedValue(precedingValue);
        if (Objects.equals(value, newValue = this.loadValueForPassingRow(value, context)) && precedingValue.isDefined()) {
            return precedingValue;
        }
        return AttributeValue.ofNullable(newValue);
    }

    @Nullable
    protected abstract T loadValueForPassingRow(@Nullable T var1, ScanningAttributeContext var2);

    protected boolean isRowSkipped(AttributeValue<T> precedingValue, ScanningAttributeContext context) {
        return false;
    }

    private T getCarriedValue(AttributeValue<T> value) {
        return (T)(value.isDefined() ? value.getValue() : value.getLoaderData(Object.class));
    }

    protected AttributeValue<T> carryPrecedingValueForSkippedRow(AttributeValue<T> precedingValue) {
        return precedingValue.isDefined() ? AttributeValue.undefined().withData(precedingValue.getValue()) : precedingValue;
    }

    @Nullable
    private static IntList getLevels(SpecParams params, int baseLevel) {
        if (!params.has("levels")) {
            return null;
        }
        IntArray levels = IntArray.create(params.getIntList("levels"));
        for (int i = 0; i < levels.size(); ++i) {
            levels.set(i, levels.get(i) - 1);
        }
        levels.sortUnique();
        int idx = levels.binarySearch(baseLevel);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (idx > 0) {
            levels.removeRange(0, idx);
        }
        return levels;
    }
}

