package com.almworks.jira.structure.api.settings;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import org.jetbrains.annotations.NotNull;

import java.util.*;

import static com.almworks.jira.structure.api.settings.AttributeSensitivityMode.STANDARD;
import static java.util.Collections.emptySet;

public class ImmutableAttributeSensitivitySettingsBean implements AttributeSensitivitySettings {
  public static final AttributeSensitivitySettings DEFAULT = new ImmutableAttributeSensitivitySettingsBean(STANDARD, emptySet());

  @NotNull
  private final AttributeSensitivityMode mySensitivityMode;
  @NotNull
  private final Set<AttributeSpec<?>> myNonSensitiveAttributes;

  public ImmutableAttributeSensitivitySettingsBean(@NotNull AttributeSensitivityMode sensitivityMode,
    @NotNull Collection<? extends AttributeSpec<?>> nonSensitiveAttributes)
  {
    mySensitivityMode = sensitivityMode;
    myNonSensitiveAttributes = Collections.unmodifiableSet(new HashSet<>(nonSensitiveAttributes));
  }

  @NotNull
  @Override
  public AttributeSensitivityMode getSensitivityMode() {
    return mySensitivityMode;
  }

  @NotNull
  @Override
  public Set<AttributeSpec<?>> getNonSensitiveAttributes() {
    return myNonSensitiveAttributes;
  }
}
