package com.almworks.jira.structure.api.attribute.loader;

import com.atlassian.annotations.PublicSpi;
import org.jetbrains.annotations.Nullable;

/**
 * <p>A multi-row loader provide a value for a single row, but also considering the previously calculated value of the same
 * attribute for some other rows in the forest. This is the base interface for all multi-row loaders.</p>
 *
 * @param <T> type of the loaded value
 *
 * @see AggregateAttributeLoader
 * @see PropagateAttributeLoader
 * @see ScanningAttributeLoader
 */
@PublicSpi
public interface MultiRowAttributeLoader<T> extends RowAttributeLoader<T> {
  @Nullable
  @Override
  default AttributeCachingStrategy getCachingStrategy() {
    return AttributeCachingStrategy.SHOULD;
  }
}
