/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.fugue.Function2;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapObject {
    public static final MapObject EMPTY = new MapObject(Collections.emptyMap());
    public static final Function2<JSONArray, Integer, Long> LONG_ARRAY_EXTRACTOR = new Function2<JSONArray, Integer, Long>(){

        public Long apply(JSONArray jsonArray, Integer index) {
            Object v = jsonArray.opt(index.intValue());
            return v instanceof Number ? Long.valueOf(((Number)v).longValue()) : null;
        }
    };
    public static final Function2<JSONArray, Integer, String> STRING_ARRAY_EXTRACTOR = new Function2<JSONArray, Integer, String>(){

        public String apply(JSONArray jsonArray, Integer index) {
            return jsonArray.optString(index.intValue(), null);
        }
    };
    public static final Function2<JSONArray, Integer, Object> RAW_OBJECT_ARRAY_EXTRACTOR = new Function2<JSONArray, Integer, Object>(){

        public Object apply(JSONArray jsonArray, Integer index) {
            return jsonArray.opt(index.intValue());
        }
    };
    public static final Function2<JSONArray, Integer, MapObject> MAP_OBJECT_ARRAY_EXTRACTOR = new Function2<JSONArray, Integer, MapObject>(){

        public MapObject apply(JSONArray array, Integer i) {
            return MapObject.from(array.opt(i.intValue()));
        }
    };
    @NotNull
    protected final JSONObject myObject;
    protected MapView myMapView;

    public MapObject(JSONObject object) {
        this.myObject = object == null ? new JSONObject() : object;
    }

    public MapObject(Map<String, Object> map) {
        this.myObject = new JSONObject(map);
    }

    public static MapObject from(Object obj) {
        if (obj instanceof JSONObject) {
            return new MapObject((JSONObject)obj);
        }
        if (obj instanceof Map) {
            return new MapObject(StructureUtil.mapType().cast(obj));
        }
        return null;
    }

    public static <T> List<T> transform(JSONArray array, Function2<JSONArray, Integer, T> extractor) {
        if (array == null || array.length() == 0) {
            return Collections.emptyList();
        }
        int length = array.length();
        ArrayList<Object> r = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = extractor.apply((Object)array, (Object)i);
            if (value == null) continue;
            r.add(value);
        }
        return r;
    }

    public boolean isEmpty() {
        return this.myObject.length() == 0;
    }

    public boolean has(String key) {
        return this.myObject.has(key);
    }

    @Nullable
    public MapObject getObject(String name) {
        Object value = this.myObject.opt(name);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONObject) {
            return new MapObject((JSONObject)value);
        }
        if (value instanceof Map) {
            return new MapObject(StructureUtil.mapType().cast(value));
        }
        return null;
    }

    @NotNull
    public MapObject traverse(String name) {
        MapObject r = this.getObject(name);
        return r == null ? EMPTY : r;
    }

    @NotNull
    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return MapObject.this.myObject.keys();
            }
        };
    }

    @Nullable
    public Object get(String key) {
        return this.myObject.opt(key);
    }

    @Nullable
    public String getString(String key) {
        return this.myObject.optString(key, null);
    }

    public long getLong(String key) {
        return this.myObject.optLong(key, 0L);
    }

    public int getInt(String key) {
        return this.myObject.optInt(key, 0);
    }

    public boolean getBoolean(String key) {
        return this.myObject.optBoolean(key);
    }

    @NotNull
    public List<Long> getLongList(@Nullable String key) {
        return this.getList(key, LONG_ARRAY_EXTRACTOR);
    }

    @NotNull
    public List<String> getStringList(@Nullable String key) {
        return this.getList(key, STRING_ARRAY_EXTRACTOR);
    }

    @NotNull
    public List<Object> getRawObjectList(@Nullable String key) {
        return this.getList(key, RAW_OBJECT_ARRAY_EXTRACTOR);
    }

    @NotNull
    public List<MapObject> getObjectList(@Nullable String key) {
        return this.getList(key, MAP_OBJECT_ARRAY_EXTRACTOR);
    }

    @NotNull
    public <T> List<T> getList(@Nullable String key, Function2<JSONArray, Integer, T> extractor) {
        if (key == null) {
            return Collections.emptyList();
        }
        Object obj = this.myObject.opt(key);
        Object array = obj instanceof JSONArray ? (JSONArray)obj : (obj instanceof Collection ? new JSONArray((Collection)obj) : null);
        return MapObject.transform(array, extractor);
    }

    public Map<String, Object> asImmutableMap() {
        if (this.myMapView == null) {
            this.myMapView = new MapView();
        }
        return this.myMapView;
    }

    public String toString() {
        return this.myObject.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapObject mapObject = (MapObject)o;
        return this.myObject.equals((Object)mapObject.myObject);
    }

    public int hashCode() {
        return this.myObject.hashCode();
    }

    private class SetView
    extends AbstractSet<Map.Entry<String, Object>> {
        private SetView() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new SetIterator();
        }

        @Override
        public int size() {
            return MapObject.this.myObject.length();
        }

        private class SetIterator
        implements Iterator<Map.Entry<String, Object>> {
            private final Iterator<String> keysIt;

            private SetIterator() {
                this.keysIt = MapObject.this.myObject.keys();
            }

            @Override
            public boolean hasNext() {
                return this.keysIt.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                String key = this.keysIt.next();
                Object value = MapObject.this.myObject.opt(key);
                return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class MapView
    extends AbstractMap<String, Object> {
        private SetView mySetView;

        private MapView() {
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.mySetView == null) {
                this.mySetView = new SetView();
            }
            return this.mySetView;
        }

        @Override
        public Object get(Object key) {
            return MapObject.this.myObject.opt((String)key);
        }

        @Override
        public boolean containsKey(Object key) {
            return MapObject.this.myObject.has((String)key);
        }

        @Override
        public int size() {
            return MapObject.this.myObject.length();
        }

        @Override
        public boolean isEmpty() {
            return MapObject.this.myObject.length() == 0;
        }
    }
}

