/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.query;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntList;
import com.almworks.jira.structure.api.query.QueryContext;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.util.MessageSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@PublicSpi
public interface StructureQueryConstraint {
    public MessageSet validate(@NotNull List<String> var1);

    public Sequence filter(@NotNull IntIterator var1, @NotNull List<String> var2, @NotNull QueryContext var3);

    public static abstract class BulkFilter
    implements Sequence {
        private final IntIterator myInput;
        private final IntArray myCurrentInput;
        protected final int myBulkSize;

        protected BulkFilter(IntIterator input, int bulkSize) {
            this.myInput = input;
            this.myCurrentInput = new IntArray(bulkSize);
            this.myBulkSize = bulkSize;
        }

        @Override
        public boolean advance(Acceptor acceptor) {
            this.myCurrentInput.clear();
            this.myCurrentInput.addAllNotMore((IntIterable)this.myInput, this.myBulkSize);
            if (this.myCurrentInput.isEmpty()) {
                return false;
            }
            this.bulkFilter((IntList)this.myCurrentInput, acceptor);
            return true;
        }

        protected abstract void bulkFilter(IntList var1, Acceptor var2);
    }

    public static abstract class SimpleFilter
    implements Sequence {
        private final IntIterator myInput;

        protected SimpleFilter(IntIterator input) {
            this.myInput = input;
        }

        public abstract boolean matches(int var1);

        @Override
        public boolean advance(Acceptor acceptor) {
            if (!this.myInput.hasNext()) {
                return false;
            }
            if (this.matches(this.myInput.nextValue())) {
                acceptor.accept(this.myInput.value());
            }
            return true;
        }
    }

    public static class EmptySequence
    implements Sequence {
        @Override
        public boolean advance(Acceptor acceptor) {
            return false;
        }
    }

    @PublicApi
    public static interface Acceptor {
        public void accept(int var1);

        public void accept(IntIterable var1);

        public void willAccept(int var1);
    }

    @PublicSpi
    public static interface Sequence {
        public static final Sequence EMPTY = new EmptySequence();

        public boolean advance(Acceptor var1);
    }
}

