/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.AbstractAggregateLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.reduce.ValueReducer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReductionStrategy<T> {
    @NotNull
    public AttributeValue<T> apply(@NotNull Supplier<AttributeValue<T>> var1, @NotNull List<AttributeValue<T>> var2, @NotNull ValueReducer<T> var3);

    @NotNull
    public static String getStrategyType(@NotNull AttributeSpec<?> attributeSpec) {
        return attributeSpec.getParamsMap().getOrDefault("type", "subtree").toString();
    }

    @NotNull
    public static <T> ReductionStrategy<T> forAttributeSpec(@NotNull AttributeSpec<?> attributeSpec) {
        String strategyType = ReductionStrategy.getStrategyType(attributeSpec);
        return ReductionStrategy.forStrategyType(strategyType);
    }

    @NotNull
    public static <T> ReductionStrategy<T> forStrategyType(@NotNull String strategyType) {
        switch (strategyType) {
            case "children": {
                return ChildrenReductionStrategy.INSTANCE;
            }
            case "leaves": {
                return LeavesReductionStrategy.INSTANCE;
            }
            case "strict": {
                return StrictReductionStrategy.INSTANCE;
            }
            case "subtree": {
                return SubtreeReductionStrategy.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unknown strategy type '" + strategyType + "'");
    }

    public static class SubtreeReductionStrategy<T>
    extends AbstractReductionStrategy<T> {
        private static final SubtreeReductionStrategy<?> INSTANCE = new SubtreeReductionStrategy();

        @Override
        @NotNull
        public AttributeValue<T> apply(@NotNull Supplier<AttributeValue<T>> selfSupplier, @NotNull List<AttributeValue<T>> children, @NotNull ValueReducer<T> reducer) {
            return this.processSelfValue(selfSupplier, TrailItemSet.fromValues(children), supplier -> reducer.merge((Supplier<T>)supplier, this.valueList(children)));
        }
    }

    public static class StrictReductionStrategy<T>
    extends AbstractReductionStrategy<T> {
        private static final StrictReductionStrategy<?> INSTANCE = new StrictReductionStrategy();

        @Override
        @NotNull
        public AttributeValue<T> apply(@NotNull Supplier<AttributeValue<T>> selfSupplier, @NotNull List<AttributeValue<T>> children, @NotNull ValueReducer<T> reducer) {
            AttributeValue attributeValue = this.reduceValuesInChildrenAdditionalData(children, reducer);
            AttributeValue<Object> withSelf = this.processSelfValue(selfSupplier, attributeValue.getAdditionalDataTrail(), supplier -> reducer.merge((Supplier)supplier, attributeValue::getValue));
            return attributeValue.withData(withSelf);
        }
    }

    public static class LeavesReductionStrategy<T>
    extends AbstractReductionStrategy<T> {
        private static final LeavesReductionStrategy<?> INSTANCE = new LeavesReductionStrategy();

        @Override
        @NotNull
        public AttributeValue<T> apply(@NotNull Supplier<AttributeValue<T>> selfSupplier, @NotNull List<AttributeValue<T>> children, @NotNull ValueReducer<T> reducer) {
            if (children.isEmpty()) {
                return this.processSelfValue(selfSupplier, null, reducer::convert);
            }
            return AttributeValue.ofNullable(reducer.reduce(this.valueList(children))).withTrail(TrailItemSet.fromValues(children));
        }
    }

    public static class ChildrenReductionStrategy<T>
    extends AbstractReductionStrategy<T> {
        private static final ChildrenReductionStrategy<?> INSTANCE = new ChildrenReductionStrategy();

        @Override
        @NotNull
        public AttributeValue<T> apply(@NotNull Supplier<AttributeValue<T>> selfSupplier, @NotNull List<AttributeValue<T>> children, @NotNull ValueReducer<T> reducer) {
            AttributeValue<T> value = this.reduceValuesInChildrenAdditionalData(children, reducer);
            return value.withData(selfSupplier.get());
        }
    }

    public static abstract class AbstractReductionStrategy<T>
    implements ReductionStrategy<T> {
        static final Logger logger = LoggerFactory.getLogger(ReductionStrategy.class);

        @NotNull
        AttributeValue<T> processSelfValue(Supplier<AttributeValue<T>> selfSupplier, TrailItemSet trailItemSet, Function<Supplier<T>, T> errorUnawareProcessor) {
            AtomicReference error = new AtomicReference();
            AtomicReference trail = new AtomicReference();
            Supplier<Object> errorRecordingSupplier = () -> {
                AttributeValue value = (AttributeValue)selfSupplier.get();
                if (value == null) {
                    return null;
                }
                if (value.isError()) {
                    error.set(value);
                }
                trail.set(value.getAdditionalDataTrail());
                return value.getValue();
            };
            T value = errorUnawareProcessor.apply(errorRecordingSupplier);
            return error.get() != null ? (AttributeValue<T>)error.get() : AttributeValue.ofNullable(value).withTrail((TrailItemSet)Stream.of(trailItemSet, (TrailItemSet)trail.get()).filter(t -> t != null && !t.isEmpty()).reduce(TrailItemSet::expand).orElse(null));
        }

        @NotNull
        AttributeValue<T> reduceValuesInChildrenAdditionalData(@NotNull List<AttributeValue<T>> children, @NotNull ValueReducer<T> reducer) {
            List additionalDataList = Lists.transform(children, this::getAdditionalData);
            AttributeValue error = AbstractAggregateLoader.firstChildError(additionalDataList);
            if (error != null) {
                return error;
            }
            try {
                T value = reducer.reduce(Lists.transform((List)additionalDataList, v -> v != null ? v.getValue() : null));
                return AttributeValue.ofNullable(value).withTrail(TrailItemSet.fromValues(additionalDataList));
            }
            catch (ClassCastException e) {
                logger.error("error reducing children values", (Throwable)e);
                return AttributeValue.error();
            }
        }

        @NotNull
        <D> AttributeValue<D> getAdditionalData(AttributeValue<D> child) {
            if (child == null) {
                return AttributeValue.undefined();
            }
            AttributeValue value = child.getLoaderData(AttributeValue.class);
            return value != null ? value : AttributeValue.undefined();
        }

        @NotNull
        List<T> valueList(@NotNull List<AttributeValue<T>> attributeValueList) {
            return Lists.transform(attributeValueList, v -> v == null ? null : v.getValue());
        }
    }
}

