/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.distinct;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeSpecBuilder;
import com.almworks.jira.structure.api.attribute.loader.AbstractAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.distinct.DistinctAttributes;
import com.almworks.jira.structure.api.attribute.loader.reduce.ReductionStrategy;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDistinctSumLoader<T, E, X>
extends AbstractAttributeLoader<T>
implements AttributeLoader.ForestIndependent<T> {
    private final ImmutableSet<AttributeSpec<?>> myDependencies;
    private final AttributeSpec<Map<ItemIdentity, E>> myDependentValuesSpec;
    private final AttributeSpec<T> myNonDistinctSpec;
    private final AttributeSpec<Map<ItemIdentity, Integer>> myNonUniqueItemsSpec;
    private final boolean myStrict;

    public AbstractDistinctSumLoader(AttributeSpec<T> spec, AttributeSpec<T> nonDistinctSpec, AttributeSpec<E> dependentAttribute) {
        super(spec);
        this.myNonDistinctSpec = nonDistinctSpec;
        String type = ReductionStrategy.getStrategyType(spec);
        this.myStrict = "strict".equals(type);
        if (this.myStrict || "subtree".equals(type)) {
            type = null;
        }
        this.myDependentValuesSpec = AttributeSpecBuilder.create("-non-unique-items", DistinctAttributes.nonUniqueValuesValueFormat()).params().setAttribute(dependentAttribute).set("type", type).build();
        this.myNonUniqueItemsSpec = AttributeSpecBuilder.create("-non-unique-items", DistinctAttributes.MAP_ITEM_COUNT_FORMAT).params().set("type", type).build();
        this.myDependencies = ImmutableSet.of(this.myNonDistinctSpec, dependentAttribute, this.myNonUniqueItemsSpec, this.myDependentValuesSpec);
    }

    @Override
    public final boolean isEveryItemTypeSupported() {
        return true;
    }

    @Override
    public final boolean isItemTypeSupported(String itemType) {
        return true;
    }

    @Override
    public AttributeCachingStrategy getCachingStrategy() {
        return AttributeCachingStrategy.SHOULD;
    }

    @Override
    @NotNull
    public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
        return this.myDependencies;
    }

    @Nullable
    protected Map<ItemIdentity, E> getChildrenValues(AttributeLoader.Context context) {
        AttributeValue<Map<ItemIdentity, E>> value = context.getAttributeValue(this.myDependentValuesSpec);
        return value == null ? null : value.getValue();
    }

    @Nullable
    protected Map<ItemIdentity, Integer> getChildrenCounts(AttributeLoader.Context context) {
        AttributeValue<Map<ItemIdentity, Integer>> value = context.getAttributeValue(this.myNonUniqueItemsSpec);
        return value == null ? null : value.getValue();
    }

    @Nullable
    protected abstract X initializeWithNonDistinctValue(T var1);

    @NotNull
    protected abstract X removeDuplicates(@NotNull X var1, @NotNull E var2, int var3);

    protected abstract AttributeValue<T> finalize(X var1);

    @Override
    public AttributeValue<T> loadValue(StructureRow row, AttributeLoader.Context context) {
        AttributeValue<T> totalValue = context.getAttributeValue(this.myNonDistinctSpec);
        if (totalValue == null) {
            return AttributeValue.undefined();
        }
        if (totalValue.isError() || !totalValue.isDefined()) {
            return totalValue;
        }
        X total = this.initializeWithNonDistinctValue(totalValue.getValue());
        if (total == null) {
            return AttributeValue.undefined();
        }
        Map<ItemIdentity, Integer> maybeDuplicateCounts = this.getChildrenCounts(context);
        Map<ItemIdentity, E> maybeDuplicatedValues = this.getChildrenValues(context);
        ItemIdentity itemId = context.getRow().getItemId();
        if (maybeDuplicateCounts != null && maybeDuplicatedValues != null) {
            for (Map.Entry<ItemIdentity, Integer> e : maybeDuplicateCounts.entrySet()) {
                E duplicatedValue;
                Integer count = e.getValue();
                if (count == null || (duplicatedValue = maybeDuplicatedValues.get(e.getKey())) == null) continue;
                if (this.myStrict && itemId.equals(e.getKey())) {
                    count = count - 1;
                }
                if (count <= 1) continue;
                total = this.removeDuplicates(total, duplicatedValue, count - 1);
            }
        }
        return this.finalize(total).withTrail(totalValue.getAdditionalDataTrail());
    }
}

