/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractPropagateLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class InheritedValueLoader<T>
extends AbstractPropagateLoader<T> {
    private final AttributeSpec<T> myValueSpec;

    public InheritedValueLoader(AttributeSpec<T> spec, AttributeSpec<T> valueSpec) {
        super(spec);
        this.myValueSpec = valueSpec;
    }

    @Override
    public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myValueSpec);
    }

    @Override
    public List<AttributeValue<T>> loadChildrenValues(AttributeValue<T> rowValue, List<StructureRow> children, AttributeLoader.PropagateContext<T> context) {
        if (rowValue == null) {
            rowValue = AttributeValue.undefined();
        }
        ArrayList<AttributeValue<T>> result = new ArrayList<AttributeValue<T>>(children.size());
        for (StructureRow child : children) {
            AttributeValue<T> childValue = context.getChildAttributeValue(child, this.myValueSpec);
            if (childValue == null || !childValue.isDefined()) {
                childValue = rowValue;
            }
            result.add(childValue);
        }
        return result;
    }
}

