/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.ItemTypeAttributeLoader;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;

public abstract class ItemClassAttributeLoader<T, A>
extends ItemTypeAttributeLoader<A> {
    private final Class<T> myItemClass;

    public ItemClassAttributeLoader(AttributeSpec<A> spec, Class<T> itemClass, String ... itemTypes) {
        super(spec, itemTypes);
        if (itemClass == null) {
            throw new IllegalArgumentException("item class is not defined");
        }
        this.myItemClass = itemClass;
    }

    @Override
    @NotNull
    public final AttributeValue<A> getItemValue(@NotNull StructureRow row, @NotNull AttributeLoader.Context context) {
        T item = row.getItem(this.myItemClass);
        if (item == null) {
            return AttributeValue.undefined();
        }
        return this.getValue(item, context);
    }

    protected abstract AttributeValue<A> getValue(@NotNull T var1, AttributeLoader.Context var2);
}

