/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractForestIndependentAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DerivedAttributeLoader<T, D>
extends AbstractForestIndependentAttributeLoader<T> {
    protected final AttributeSpec<? extends D> myDependency;

    protected DerivedAttributeLoader(AttributeSpec<T> spec, AttributeSpec<? extends D> dependency) {
        super(spec);
        this.myDependency = dependency;
    }

    @Override
    public final Set<? extends AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myDependency);
    }

    @Override
    @NotNull
    public final AttributeValue<T> loadValue(StructureRow row, @NotNull AttributeLoader.Context context) {
        ItemIdentity trail;
        AttributeValue<D> dependentResult = context.getAttributeValue(this.myDependency);
        if (dependentResult.isError()) {
            AttributeSpec spec = this.getAttributeSpec();
            return spec == null ? AttributeValue.error() : dependentResult.cast(spec);
        }
        if (!dependentResult.isDefined()) {
            AttributeSpec spec = this.getAttributeSpec();
            return spec == null ? AttributeValue.undefined() : dependentResult.cast(spec);
        }
        D dependentValue = dependentResult.getValue();
        T value = this.getValue(dependentValue, context);
        AttributeValue<T> result = AttributeValue.derived(value, dependentResult);
        if (dependentValue != null && (trail = this.getItemTrail(dependentValue)) != null) {
            result = result.withTrail(trail);
        }
        return result;
    }

    protected ItemIdentity getItemTrail(@NotNull D value) {
        return null;
    }

    protected abstract T getValue(@Nullable D var1, AttributeLoader.Context var2);

    public static <T> AttributeLoader<T> idLoader(AttributeSpec<T> spec, AttributeSpec<T> dependency) {
        if (spec.getFormat() != dependency.getFormat()) {
            return null;
        }
        return new DerivedAttributeLoader<T, T>((AttributeSpec)spec, dependency){

            @Override
            protected T getValue(@Nullable T value, AttributeLoader.Context context) {
                return value;
            }
        };
    }
}

