/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.darkfeature.DarkFeatures;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public abstract class TrailItemSet {
    private static final int SPECIFIC_ITEMS_LIMIT = DarkFeatures.getInteger("structure.trail.itemLimit", 0x7FFFFFFE);
    private static final int SPECIFIC_TYPES_LIMIT = DarkFeatures.getInteger("structure.trail.typeLimit", 10);
    private int myHashCode;

    private TrailItemSet() {
    }

    public abstract boolean contains(@Nullable ItemIdentity var1);

    @NotNull
    public abstract TrailItemSet expand(@Nullable ItemIdentity var1);

    @NotNull
    public abstract TrailItemSet expand(@Nullable TrailItemSet var1);

    public abstract void accept(@NotNull Visitor var1);

    public final boolean isEmpty() {
        return this.cardinality() == 0;
    }

    abstract int cardinality();

    public final boolean equals(Object obj) {
        if (!(obj instanceof TrailItemSet)) {
            return false;
        }
        TrailItemSet that = (TrailItemSet)obj;
        if (this.cardinality() != that.cardinality()) {
            return false;
        }
        return Collector.collect(this).equals(Collector.collect(that));
    }

    public final int hashCode() {
        int hashCode = this.myHashCode;
        if (hashCode == 0) {
            hashCode = Collector.collect(this).hashCode();
            if (hashCode == 0) {
                hashCode = -1;
            }
            this.myHashCode = hashCode;
        }
        return hashCode;
    }

    public final String toString() {
        return Collector.collect(this).toString();
    }

    public static TrailItemSet of(ItemIdentity ... ids) {
        if (ids == null || ids.length == 0) {
            return None.NONE;
        }
        if (ids.length == 1) {
            return new OneItem(ids[0]);
        }
        if (ids.length <= SPECIFIC_ITEMS_LIMIT) {
            return new SpecificItems(Arrays.asList(ids));
        }
        return TrailItemSet.ofTypesGivenItems(Arrays.asList(ids), null);
    }

    public static TrailItemSet ofTypes(Collection<String> types) {
        if (types == null || types.isEmpty()) {
            return None.NONE;
        }
        if (types.size() == 1) {
            return new OneType(types.iterator().next());
        }
        if (types.size() <= SPECIFIC_TYPES_LIMIT) {
            return new SpecificTypes(types);
        }
        return AllItems.ALL_ITEMS;
    }

    @Nullable
    public static TrailItemSet fromValues(Collection<? extends AttributeValue<?>> values) {
        return values.stream().filter(Objects::nonNull).map(AttributeValue::getAdditionalDataTrail).filter(trail -> !trail.isEmpty()).reduce(TrailItemSet::expand).orElse(null);
    }

    private static TrailItemSet ofTypesGivenItems(Collection<ItemIdentity> items, @Nullable ItemIdentity oneMoreItem) {
        Stream<ItemIdentity> stream = items.stream();
        if (oneMoreItem != null) {
            stream = Stream.concat(stream, Stream.of(oneMoreItem));
        }
        Set<String> types = stream.map(id -> id == null ? null : id.getItemType()).filter(Objects::nonNull).collect(Collectors.toSet());
        return TrailItemSet.ofTypes(types);
    }

    private static TrailItemSet mergeItemsToTypes(TrailItemSet typesSet, TrailItemSet itemsSet) {
        if (itemsSet instanceof OneItem) {
            OneItem oneItem = (OneItem)itemsSet;
            return typesSet.expand(oneItem.myItem);
        }
        if (itemsSet instanceof SpecificItems) {
            SpecificItems items2 = (SpecificItems)itemsSet;
            return typesSet.expand(TrailItemSet.ofTypesGivenItems(items2.myItems, null));
        }
        assert (itemsSet instanceof AllItems);
        return AllItems.ALL_ITEMS;
    }

    public static class Collector
    implements ReadVisitor {
        private Set<String> myTypes;
        private Set<ItemIdentity> myItems;
        private boolean myAll;

        private Collector(int cardinality) {
            if (cardinality > 0 && cardinality < Integer.MAX_VALUE) {
                this.myItems = new HashSet<ItemIdentity>(cardinality);
            } else if (cardinality < 0) {
                this.myTypes = new HashSet<String>(-cardinality);
            }
        }

        public static Collector collect(TrailItemSet set) {
            Collector collector = new Collector(set.cardinality());
            set.accept(collector);
            return collector;
        }

        public Set<String> getTypes() {
            return this.myTypes;
        }

        public Set<ItemIdentity> getItems() {
            return this.myItems;
        }

        public boolean isAll() {
            return this.myAll;
        }

        @Override
        public void visitItem(ItemIdentity item) {
            if (this.myItems == null) {
                assert (false) : "set reported bad cardinality [" + item + "]";
                this.myItems = new HashSet<ItemIdentity>();
            }
            this.myItems.add(item);
        }

        @Override
        public void visitType(String type) {
            if (this.myTypes == null) {
                assert (false) : "set reported bad cardinality [" + type + "]";
                this.myTypes = new HashSet<String>();
            }
            this.myTypes.add(type);
        }

        @Override
        public void visitAll() {
            this.myAll = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Collector collector = (Collector)o;
            return this.myAll == collector.myAll && Objects.equals(this.myTypes, collector.myTypes) && Objects.equals(this.myItems, collector.myItems);
        }

        public int hashCode() {
            return Objects.hash(this.myTypes, this.myItems, this.myAll);
        }

        public String toString() {
            if (this.myAll) {
                return "{ALL}";
            }
            String types = this.myTypes == null ? "" : StringUtils.join(this.myTypes, (char)',');
            String items = this.myItems == null ? "" : StringUtils.join(this.myItems, (char)',');
            String comma = types != null && items != null ? "," : "";
            return "{" + types + comma + items + "}";
        }
    }

    public static interface ReadVisitor
    extends Visitor {
        public void visitItem(ItemIdentity var1);

        public void visitType(String var1);

        @Override
        default public void visitNone() {
        }

        @Override
        default public void visit(OneItem set) {
            this.visitItem(set.getItem());
        }

        @Override
        default public void visit(SpecificItems set) {
            for (ItemIdentity item : set.getItems()) {
                this.visitItem(item);
            }
        }

        @Override
        default public void visit(OneType set) {
            this.visitType(set.getItemType());
        }

        @Override
        default public void visit(SpecificTypes set) {
            for (String type : set.getTypes()) {
                this.visitType(type);
            }
        }
    }

    public static interface Visitor {
        public void visitNone();

        public void visit(OneItem var1);

        public void visit(SpecificItems var1);

        public void visit(OneType var1);

        public void visit(SpecificTypes var1);

        public void visitAll();
    }

    public static final class AllItems
    extends TrailItemSet {
        public static final TrailItemSet ALL_ITEMS = new AllItems();

        @Override
        public boolean contains(ItemIdentity id) {
            return true;
        }

        @Override
        @NotNull
        public TrailItemSet expand(ItemIdentity trailItem) {
            return this;
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            return this;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visitAll();
        }

        @Override
        int cardinality() {
            return Integer.MAX_VALUE;
        }
    }

    public static final class SpecificTypes
    extends TrailItemSet {
        @NotNull
        private final Set<String> myTypes;

        public SpecificTypes(Collection<String> types) {
            this(types.stream());
        }

        public SpecificTypes(Stream<String> stream) {
            this.myTypes = Collections.synchronizedSet(Collections.unmodifiableSet(stream.collect(Collectors.toSet())));
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && this.myTypes.contains(id.getItemType());
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || this.myTypes.contains(trailItem.getItemType())) {
                return this;
            }
            if (this.myTypes.size() >= SPECIFIC_TYPES_LIMIT) {
                return AllItems.ALL_ITEMS;
            }
            return new SpecificTypes(Stream.concat(this.myTypes.stream(), Stream.of(trailItem.getItemType())));
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            if (trailItemSet == null || trailItemSet instanceof None) {
                return this;
            }
            if (trailItemSet instanceof OneType) {
                OneType oneType = (OneType)trailItemSet;
                if (this.myTypes.contains(oneType.myItemType)) {
                    return this;
                }
                return this.expand(Collections.singleton(oneType.myItemType));
            }
            if (trailItemSet instanceof SpecificTypes) {
                SpecificTypes plusTypes = (SpecificTypes)trailItemSet;
                if (this.myTypes.containsAll(plusTypes.myTypes)) {
                    return this;
                }
                return this.expand(plusTypes.myTypes);
            }
            return TrailItemSet.mergeItemsToTypes((TrailItemSet)this, trailItemSet);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return -this.myTypes.size();
        }

        @NotNull
        public Set<String> getTypes() {
            return this.myTypes;
        }

        private TrailItemSet expand(Set<String> newTypes) {
            HashSet<String> types = new HashSet<String>(this.myTypes);
            types.addAll(newTypes);
            return types.size() > SPECIFIC_TYPES_LIMIT ? AllItems.ALL_ITEMS : new SpecificTypes(types);
        }
    }

    public static final class OneType
    extends TrailItemSet {
        @NotNull
        private final String myItemType;

        public OneType(@NotNull String itemType) {
            if (itemType == null) {
                throw new IllegalArgumentException("null itemType");
            }
            this.myItemType = itemType;
        }

        @NotNull
        public String getItemType() {
            return this.myItemType;
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && id.getItemType().equals(this.myItemType);
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null) {
                return this;
            }
            String itemType = trailItem.getItemType();
            if (itemType.equals(this.myItemType)) {
                return this;
            }
            return new SpecificTypes(Arrays.asList(this.myItemType, itemType));
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            if (trailItemSet == null || trailItemSet instanceof None) {
                return this;
            }
            if (trailItemSet instanceof OneType) {
                OneType oneType = (OneType)trailItemSet;
                if (oneType.myItemType.equals(this.myItemType)) {
                    return this;
                }
                return OneType.ofTypes(Sets.newHashSet((Object[])new String[]{this.myItemType, oneType.myItemType}));
            }
            if (trailItemSet instanceof SpecificTypes) {
                SpecificTypes types = (SpecificTypes)trailItemSet;
                return types.expand(Collections.singleton(this.myItemType));
            }
            return TrailItemSet.mergeItemsToTypes((TrailItemSet)this, trailItemSet);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return -1;
        }
    }

    public static final class SpecificItems
    extends TrailItemSet {
        @NotNull
        private final Set<ItemIdentity> myItems;

        public SpecificItems(Collection<ItemIdentity> items) {
            this(items.stream());
        }

        public SpecificItems(Stream<ItemIdentity> stream) {
            this.myItems = Collections.synchronizedSet(Collections.unmodifiableSet(stream.collect(Collectors.toSet())));
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return this.myItems.contains(id);
        }

        @NotNull
        public Set<ItemIdentity> getItems() {
            return this.myItems;
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || this.myItems.contains(trailItem)) {
                return this;
            }
            if (this.myItems.size() >= SPECIFIC_ITEMS_LIMIT) {
                return TrailItemSet.ofTypesGivenItems(this.myItems, trailItem);
            }
            return new SpecificItems(Stream.concat(this.myItems.stream(), Stream.of(trailItem)));
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            if (trailItemSet == null || trailItemSet instanceof None) {
                return this;
            }
            if (trailItemSet instanceof OneItem) {
                OneItem oneItem = (OneItem)trailItemSet;
                return this.expand(Collections.singleton(oneItem.myItem));
            }
            if (trailItemSet instanceof SpecificItems) {
                SpecificItems items = (SpecificItems)trailItemSet;
                return this.expand(items.myItems);
            }
            if (trailItemSet instanceof OneType || trailItemSet instanceof SpecificTypes) {
                return TrailItemSet.ofTypesGivenItems(this.myItems, null).expand(trailItemSet);
            }
            return AllItems.ALL_ITEMS;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return this.myItems.size();
        }

        private TrailItemSet expand(Set<ItemIdentity> newItems) {
            HashSet<ItemIdentity> items = new HashSet<ItemIdentity>(this.myItems);
            items.addAll(newItems);
            return items.size() > SPECIFIC_ITEMS_LIMIT ? TrailItemSet.ofTypesGivenItems(items, null) : new SpecificItems(items);
        }
    }

    public static final class OneItem
    extends TrailItemSet {
        @NotNull
        private final ItemIdentity myItem;

        public OneItem(@NotNull ItemIdentity item) {
            if (item == null) {
                throw new IllegalArgumentException("item cannot be null");
            }
            this.myItem = item;
        }

        @Override
        public boolean contains(ItemIdentity id) {
            return id != null && id.equals(this.myItem);
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null || trailItem.equals(this.myItem)) {
                return this;
            }
            return new SpecificItems(Arrays.asList(this.myItem, trailItem));
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            if (trailItemSet == null || trailItemSet instanceof None) {
                return this;
            }
            return trailItemSet.expand(this.myItem);
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        int cardinality() {
            return 1;
        }

        @NotNull
        public ItemIdentity getItem() {
            return this.myItem;
        }
    }

    public static final class None
    extends TrailItemSet {
        public static final TrailItemSet NONE = new None();

        @Override
        public boolean contains(ItemIdentity id) {
            return false;
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable ItemIdentity trailItem) {
            if (trailItem == null) {
                return this;
            }
            return new OneItem(trailItem);
        }

        @Override
        @NotNull
        public TrailItemSet expand(@Nullable TrailItemSet trailItemSet) {
            if (trailItemSet == null) {
                return this;
            }
            return trailItemSet;
        }

        @Override
        public void accept(@NotNull Visitor visitor) {
            visitor.visitNone();
        }

        @Override
        int cardinality() {
            return 0;
        }
    }
}

