/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongOpenHashSet;
import com.almworks.integers.LongSet;
import com.almworks.integers.LongSizedIterable;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.cache.access.ForestAccessCache;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeLoaderSecurity {
    private static final String INVISIBLE_ROW_IDS = "AttributeLoaderSecurity.INVISIBLE_ROW_IDS";

    public static void collectInvisibleRows(@NotNull LongSet rowIds, @NotNull AttributeContext context, ForestAccessCache forestAccessCache) {
        if (rowIds.isEmpty()) {
            return;
        }
        RowCheckingData data = (RowCheckingData)context.getObject(INVISIBLE_ROW_IDS);
        if (data == null) {
            data = new RowCheckingData(new LongOpenHashSet(rowIds.size()), new LongOpenHashSet());
            context.putObject(INVISIBLE_ROW_IDS, data);
        }
        LongArray checkArray = new LongArray(rowIds.size());
        for (LongIterator ri : rowIds) {
            if (!data.checkedRows.include(ri.value())) continue;
            checkArray.add(ri.value());
        }
        data.invisibleRows.addAll((LongSizedIterable)forestAccessCache.getInvisibleRows((LongList)checkArray, context.getUser()));
    }

    public static boolean isRowInvisible(AttributeLoader.Context context) {
        RowCheckingData data = AttributeLoaderSecurity.get(context);
        if (data == null) {
            return true;
        }
        assert (data.checkedRows.contains(context.getRow().getRowId())) : context.getRow().getRowId() + " " + RowCheckingData.access$100(data) + " " + RowCheckingData.access$200(data);
        return data.invisibleRows.contains(context.getRow().getRowId());
    }

    public static Predicate<Long> getRowInvisiblePredicate(AttributeContext context) {
        RowCheckingData data = AttributeLoaderSecurity.get(context);
        if (data == null) {
            return v -> true;
        }
        return row -> {
            assert (data.checkedRows.contains(row.longValue())) : row + " " + RowCheckingData.access$100(data) + " " + RowCheckingData.access$200(data);
            return data.invisibleRows.contains(row.longValue());
        };
    }

    @Nullable
    private static RowCheckingData get(AttributeContext context) {
        try {
            return (RowCheckingData)context.getObject(INVISIBLE_ROW_IDS);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static class RowCheckingData {
        @NotNull
        private final LongOpenHashSet checkedRows;
        @NotNull
        private final LongOpenHashSet invisibleRows;

        private RowCheckingData(@NotNull LongOpenHashSet checkedRows, @NotNull LongOpenHashSet invisibleRows) {
            this.checkedRows = checkedRows;
            this.invisibleRows = invisibleRows;
        }
    }
}

