/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.textimport;

import com.almworks.integers.IntArray;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.StructureComponents;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.folder.Folder;
import com.almworks.jira.structure.api.folder.FolderManager;
import com.almworks.jira.structure.api.forest.ForestService;
import com.almworks.jira.structure.api.forest.ForestSource;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.almworks.jira.structure.api.forest.action.ForestAction;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilderImpl;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.structure.Structure;
import com.almworks.jira.structure.api.structure.StructureManager;
import com.almworks.structure.textimport.ImportResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextImporter {
    private static final Logger logger = LoggerFactory.getLogger(TextImporter.class);
    private static final int TAB_SIZE = 8;
    private static final Pattern CHECKVIST_COMMENT = Pattern.compile("\\s*\\w+'s note: (.*)");
    private static final int MAX_PROBLEMATIC_ISSUES = 10;
    private static final String LABEL = "imported";
    private final StructureManager myStructureManager;
    private final LabelService myLabelService;
    private final IssueService myIssueService;
    private final ImportResult myImportResult;
    private final ForestService myForestService;
    private final RowManager myRowManager;
    private final FolderManager myFolderManager;
    private Structure myStructure;
    private Project myProject;
    private IssueType myIssueType;
    private boolean myReuseExistingInStructure;
    private boolean myDecodeCheckvistComments;
    private final Map<String, Long> mySummaryToIssueId = new HashMap<String, Long>();
    private String myText;
    private long myProblematicIssues = 0L;
    private boolean myUseFolders;

    public TextImporter(StructureComponents structureComponents, LabelService labelService, IssueService issueService, ImportResult importResult) {
        this.myStructureManager = structureComponents.getStructureManager();
        this.myForestService = structureComponents.getForestService();
        this.myRowManager = structureComponents.getRowManager();
        this.myFolderManager = structureComponents.getFolderManager();
        this.myLabelService = labelService;
        this.myIssueService = issueService;
        this.myImportResult = importResult;
    }

    public void setStructure(Structure structure) {
        this.myStructure = structure;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setIssueType(IssueType issueType) {
        this.myIssueType = issueType;
    }

    public void setReuseExistingInStructure(boolean reuseExistingInStructure) {
        this.myReuseExistingInStructure = reuseExistingInStructure;
    }

    public void setDecodeCheckvistComments(boolean decodeCheckvistComments) {
        this.myDecodeCheckvistComments = decodeCheckvistComments;
    }

    public void setUseFolders(boolean useFolders) {
        this.myUseFolders = useFolders;
    }

    public void setText(String text) {
        this.myText = text;
    }

    public void runImport() throws StructureException, IssueCreationError {
        ItemForest f;
        int totalIssues;
        if (this.myReuseExistingInStructure) {
            this.buildMap();
        }
        if ((totalIssues = (f = this.buildForest()).getForest().size()) == 0) {
            throw new IssueCreationError("no issues to be imported");
        }
        if (this.myProblematicIssues > (long)Math.min(10, totalIssues / 3)) {
            throw new IssueCreationError("failed to create " + this.myProblematicIssues + " issues, aborting");
        }
        this.myImportResult.setTotalIssues(totalIssues);
        ForestSource forestSource = this.myForestService.getForestSource(ForestSpec.structure((long)this.myStructure.getId()));
        forestSource.apply((ForestAction)new ForestAction.Remove(forestSource.getLatest().getForest().getRows()));
        forestSource.apply((ForestAction)new ForestAction.Add(f, 0L, 0L, 0L));
    }

    private void buildMap() throws StructureException {
        Forest forest = this.myForestService.getForestSource(ForestSpec.structure((long)this.myStructure.getId())).getLatest().getForest();
        LongArray issues = (LongArray)this.myRowManager.collectIssueIds((LongIterable)forest.getRows(), (LongCollector)new LongArray());
        for (LongIterator ii : issues) {
            Long expunged;
            MutableIssue issue;
            IssueService.IssueResult ir = this.myIssueService.getIssue(StructureAuth.getUser(), Long.valueOf(ii.value()));
            if (ir == null || (issue = ir.getIssue()) == null || !TextImporter.equals(issue.getProjectId(), this.myProject.getId()) || !TextImporter.equals(issue.getIssueTypeId(), this.myIssueType.getId()) || (expunged = this.mySummaryToIssueId.put(issue.getSummary(), issue.getId())) == null || expunged.longValue() == ii.value()) continue;
            logger.warn("during structure text import, found multiple matching issues in the structure with the same Summary (" + issue.getSummary() + "): " + issue.getKey() + " vs " + expunged);
        }
    }

    private ItemForest buildForest() throws StructureException {
        String[] lines = this.myText.split("[\\n\\r]+");
        ArrayList<Integer> offsetStack = new ArrayList<Integer>();
        int currentDepth = -1;
        ArrayList<IssueData> issues = new ArrayList<IssueData>();
        IntArray depths = new IntArray();
        for (String line : lines) {
            String comment;
            if (line.isEmpty()) continue;
            if (this.myDecodeCheckvistComments && issues.size() > 0 && (comment = this.getCheckvistComment(line)) != null) {
                ((IssueData)issues.get(issues.size() - 1)).addComment(comment);
                continue;
            }
            int offset = this.countOffset(line);
            issues.add(new IssueData(line.trim()));
            if (currentDepth < 0 || offset > (Integer)offsetStack.get(currentDepth)) {
                if (offsetStack.size() <= ++currentDepth) {
                    assert (offsetStack.size() == currentDepth) : currentDepth + " " + offsetStack;
                    offsetStack.add(offset);
                } else {
                    offsetStack.set(currentDepth, offset);
                }
            } else {
                while (offset < (Integer)offsetStack.get(currentDepth) && currentDepth > 0) {
                    --currentDepth;
                }
                if (offset != (Integer)offsetStack.get(currentDepth)) {
                    logger.warn("inconsistent offset in line [" + line + "]");
                    offsetStack.set(currentDepth, offset);
                }
            }
            depths.add(currentDepth);
        }
        assert (issues.size() == depths.size()) : depths.size() + " " + issues.size();
        logger.info("ready to import " + issues.size() + " issues");
        return this.buildBuilder(issues, depths).build();
    }

    private ItemForestBuilderImpl buildBuilder(List<IssueData> issueIds, IntArray depths) throws StructureException {
        ItemForestBuilderImpl builder = new ItemForestBuilderImpl();
        int currentDepth = 0;
        for (int i = 0; i < depths.size(); ++i) {
            int d = depths.get(i);
            if (currentDepth < d) {
                builder.nextLevel();
                ++currentDepth;
            } else {
                while (currentDepth > d) {
                    builder.prevLevel();
                    --currentDepth;
                }
            }
            IssueData issueData = issueIds.get(i);
            if (this.myUseFolders && i + 1 < depths.size() && d < depths.get(i + 1)) {
                long folder = this.myFolderManager.createFolder(Folder.named((String)issueData.getSummary()).build());
                builder.nextRow(CoreIdentities.folder((long)folder));
                continue;
            }
            long issueId = this.createIssueFromData(issueData);
            if (issueId > 0L) {
                builder.nextRow(CoreIdentities.issue((long)issueId));
                continue;
            }
            builder.nextRow(CoreIdentities.textFolder((String)"???"));
        }
        return builder;
    }

    private LongArray createIssues(List<IssueData> issues) {
        LongArray r = new LongArray();
        for (IssueData data : issues) {
            long id = this.createIssueFromData(data);
            r.add(id);
        }
        return r;
    }

    private long createIssueFromData(IssueData data) {
        long id;
        Long existing = this.mySummaryToIssueId.remove(data.getSummary());
        if (existing != null) {
            id = existing;
        } else {
            Issue issue = this.createIssue(data);
            if (issue == null) {
                this.myImportResult.failedIssue(data.getSummary());
                ++this.myProblematicIssues;
                id = -this.myProblematicIssues;
            } else {
                this.myImportResult.issueCreated(issue);
                id = issue.getId();
            }
        }
        return id;
    }

    private Issue createIssue(IssueData data) {
        IssueService.IssueResult ir;
        ApplicationUser user;
        IssueService.CreateValidationResult r;
        IssueInputParametersImpl p = new IssueInputParametersImpl();
        p.setApplyDefaultValuesWhenParameterNotProvided(true);
        p.setSkipScreenCheck(true);
        p.setProjectId(this.myProject.getId());
        p.setIssueTypeId(this.myIssueType.getId());
        p.setSummary(data.getSummary());
        String description = data.getDescription();
        if (description != null) {
            p.setDescription(description);
        }
        if ((r = this.myIssueService.validateCreate(user = StructureAuth.getUser(), (IssueInputParameters)p)).isValid() && (ir = this.myIssueService.create(user, r)).isValid()) {
            MutableIssue issue = ir.getIssue();
            Long id = issue.getId();
            LabelService.AddLabelValidationResult lv = this.myLabelService.validateAddLabel(user, id, LABEL);
            this.myLabelService.addLabel(user, lv, false);
            return issue;
        }
        logger.warn("failed to create issue [" + data.getSummary() + "]");
        return null;
    }

    private String getCheckvistComment(String line) {
        Matcher matcher = CHECKVIST_COMMENT.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    private int countOffset(String line) {
        int r = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                r = (r / 8 + 1) * 8;
                continue;
            }
            if (!Character.isSpaceChar(c)) break;
            ++r;
        }
        return r;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static class IssueCreationError
    extends Exception {
        public IssueCreationError(String message) {
            super(message);
        }
    }

    private static class IssueData {
        private String mySummary;
        private String myDescription;

        public IssueData(String summary) {
            this.mySummary = summary;
        }

        public void addComment(String comment) {
            this.myDescription = this.myDescription == null ? comment : this.myDescription + "\n\n" + comment;
        }

        public String getSummary() {
            return this.mySummary;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

