/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.structure.textimport;

import com.almworks.jira.structure.api.StructureComponents;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.permissions.PermissionLevel;
import com.almworks.jira.structure.api.settings.StructureConfiguration;
import com.almworks.jira.structure.api.structure.Structure;
import com.almworks.jira.structure.api.structure.StructureManager;
import com.almworks.structure.textimport.ImportResult;
import com.almworks.structure.textimport.TextImporter;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ResultException;

public class StructureTextImport
extends JiraWebActionSupport {
    public static final String SECURITY_BREACH = "securitybreach";
    private final StructureManager myStructureManager;
    private final StructureConfiguration myConfiguration;
    private final StructureComponents myStructureComponents;
    private final JiraAuthenticationContext myAuthenticationContext;
    private final ProjectManager myProjectManager;
    private final PermissionManager myPermissionManager;
    private final IssueTypeManager myIssueTypeManager;
    private final IssueTypeSchemeManager myIssueTypeSchemeManager;
    private final LabelService myLabelService;
    private final IssueService myIssueService;
    private final WebResourceManager myWebResourceManager;
    private long myStructureId;
    private long myProjectId;
    private String myTypeId = "";
    private boolean myReuseExisting;
    private boolean myDecodeCheckvist;
    private boolean myUseFolders;
    private String myText = "";
    private ImportResult myImportResult = new ImportResult();

    public StructureTextImport(StructureComponents structureComponents, JiraAuthenticationContext authenticationContext, ProjectManager projectManager, PermissionManager permissionManager, IssueTypeManager issueTypeManager, IssueTypeSchemeManager issueTypeSchemeManager, LabelService labelService, IssueService issueService, WebResourceManager webResourceManager) {
        this.myStructureManager = structureComponents.getStructureManager();
        this.myConfiguration = structureComponents.getStructureConfiguration();
        this.myStructureComponents = structureComponents;
        this.myAuthenticationContext = authenticationContext;
        this.myProjectManager = projectManager;
        this.myPermissionManager = permissionManager;
        this.myIssueTypeManager = issueTypeManager;
        this.myIssueTypeSchemeManager = issueTypeSchemeManager;
        this.myLabelService = labelService;
        this.myIssueService = issueService;
        this.myWebResourceManager = webResourceManager;
    }

    public WebResourceManager getWebResourceManager() {
        return this.myWebResourceManager;
    }

    public final String doDefault() throws ResultException {
        return this.doExecute();
    }

    public final String doExecute() throws ResultException {
        this.requireStructureAccessible();
        this.myDecodeCheckvist = true;
        this.myUseFolders = true;
        return "input";
    }

    @RequiresXsrfCheck
    public final String doApply() throws ResultException {
        this.requireStructureAccessible();
        TextImporter importer = this.createImporter();
        try {
            importer.runImport();
        }
        catch (Exception e) {
            this.myImportResult.addError(e.toString());
        }
        return "success";
    }

    private TextImporter createImporter() throws ResultException {
        IssueType type;
        TextImporter importer = new TextImporter(this.myStructureComponents, this.myLabelService, this.myIssueService, this.myImportResult);
        try {
            importer.setStructure(this.myStructureManager.getStructure(Long.valueOf(this.myStructureId), PermissionLevel.EDIT));
        }
        catch (StructureException e) {
            this.fieldError("structureId", "sti.error.structure");
        }
        Project project = this.myProjectManager.getProjectObj(Long.valueOf(this.myProjectId));
        if (!(project != null && this.myPermissionManager.hasPermission(10, project, StructureAuth.getUser()) && this.myPermissionManager.hasPermission(11, project, StructureAuth.getUser()) && this.myConfiguration.isProjectEnabled(project))) {
            this.fieldError("projectId", "sti.error.project");
        }
        importer.setProject(project);
        IssueType issueType = type = StringUtils.isEmpty((String)this.myTypeId) ? null : this.myIssueTypeManager.getIssueType(this.myTypeId);
        if (type == null) {
            this.fieldError("typeId", "sti.error.issuetype");
        }
        assert (type != null);
        if (!this.myIssueTypeSchemeManager.getIssueTypesForProject(project).contains(type)) {
            this.fieldError("typeId", "sti.error.issuetype.na", type.getName());
        }
        importer.setIssueType(type);
        importer.setReuseExistingInStructure(this.myReuseExisting);
        importer.setDecodeCheckvistComments(this.myDecodeCheckvist);
        importer.setUseFolders(this.myUseFolders);
        String text = this.myText.trim();
        if (text.isEmpty()) {
            this.fieldError("text", "sti.error.text.empty");
        }
        importer.setText(text);
        return importer;
    }

    private TextImporter fieldError(String field, String errorKey, String param) throws ResultException {
        this.addError(field, this.getText(errorKey, param));
        throw new ResultException("error");
    }

    private TextImporter fieldError(String field, String errorKey) throws ResultException {
        this.addError(field, this.getText(errorKey));
        throw new ResultException("error");
    }

    protected void requireStructureAccessible() throws ResultException {
        if (!this.myConfiguration.isStructureAvailable(this.myAuthenticationContext.getLoggedInUser())) {
            throw new ResultException(SECURITY_BREACH);
        }
    }

    public boolean hasError(String field) {
        Map errors = this.getErrors();
        return errors != null && errors.containsKey(field);
    }

    @HtmlSafe
    public String getErrorHtml(String field) {
        Map errors = this.getErrors();
        if (errors == null) {
            return "";
        }
        Object v = errors.get(field);
        if (v == null) {
            return "";
        }
        return this.htmlEncode(String.valueOf(v));
    }

    public long getStructureId() {
        return this.myStructureId;
    }

    public void setStructureId(long structureId) {
        this.myStructureId = structureId;
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text) {
        this.myText = text;
    }

    public long getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(long projectId) {
        this.myProjectId = projectId;
    }

    public String getTypeId() {
        return this.myTypeId;
    }

    public void setTypeId(String typeId) {
        this.myTypeId = typeId;
    }

    public boolean isReuseExisting() {
        return this.myReuseExisting;
    }

    public void setReuseExisting(boolean reuseExisting) {
        this.myReuseExisting = reuseExisting;
    }

    public boolean isDecodeCheckvist() {
        return this.myDecodeCheckvist;
    }

    public boolean isUseFolders() {
        return this.myUseFolders;
    }

    public void setDecodeCheckvist(boolean decodeCheckvist) {
        this.myDecodeCheckvist = decodeCheckvist;
    }

    public void setUseFolders(boolean useFolders) {
        this.myUseFolders = useFolders;
    }

    public List<Structure> getStructures() {
        return this.myStructureManager.getAllStructures(PermissionLevel.EDIT);
    }

    public Collection<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>(this.myPermissionManager.getProjects(ProjectPermissions.CREATE_ISSUES, this.getLoggedInUser()));
        projects.retainAll(this.myPermissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.getLoggedInUser()));
        projects.retainAll(this.myConfiguration.getCurrentlyEnabledProjects());
        return projects;
    }

    public Collection<IssueType> getTypes() {
        return this.myIssueTypeManager.getIssueTypes();
    }

    public ImportResult getImportResult() {
        return this.myImportResult;
    }
}

