(function (window) {
  var api = window.almworks.structure.api;
  var $ = window.almworks.structure.$;
  var ajax = window.almworks.structure.ajax;
  var ajsbridge = window.almworks.structure.ajsbridge;

  // Using soy template for details rendering (see `templates/userdetails-template.soy`)
  var TEMPLATE = window.almworks.structure.example.template;

  /**
   * Declaring user details provider implementation
   */
  var UserDetailsProvider = api.subClass('UserDetails', api.ItemDetailsProvider, {
    init: function () {
      this.container$ = $(this.viewport).find('.st-user-details-container');
    },

    /**
     * Root element for details content
     */
    viewport: $('<div class="st-user-details-viewport"><div class="st-user-details-container"></div></div>')[0],

    extendFocusedRowData: function (rowData) {
      var itemId = rowData.itemId;
      // Get user key from itemId
      rowData.userKey = itemId.substring(itemId.indexOf("//") + 2, itemId.length);
      return $.Deferred().resolve(rowData);
    },

    showDetails: function (rowData) {
      // Resolved when details are shown
      var showDeferred = $.Deferred();
      var requestDeferred = $.Deferred();
      this._requestUserData(rowData.userKey, requestDeferred);
      requestDeferred.done(function (data) {
        // Replacing old content with the new one
        this.container$.empty();
        this.container$.append(TEMPLATE.userprofile(data));
        showDeferred.resolve();
      }.bind(this)).fail(function () {
        // `s.itemDetails.stub.title.+user-data-loading-error+` and `s.itemDetails.stub.body.+user-data-loading-error+`
        // messages will be used in the error stub (see `i18n/UserDetailsMessages.properties`)
        showDeferred.reject('user-data-loading-error', true);
      });
      return showDeferred;
    },

    getHeaderTitle: function () {
      return AJS.I18n.getText('userdetails.title');
    },

    /**
     * Called on Structure update for corresponding user item (e.g. changing user `Full name`)
     */
    refreshDetails: function (rowData) {
      return this.showDetails(rowData);
    },

    refreshOnStructureUpdate: true,

    /**
     * Getting data required for details rendering
     */
    _requestUserData: function (userKey, deferred) {
      ajax.doAjax({
        url: ajsbridge.localURL('/rest/api/2/user?key=' + userKey + '&expand=groups'),
        type: 'GET',
        dataType: 'json',
        success: function (data) {
          deferred.resolve({
            username: data.name,
            avatarUrl: data.avatarUrls['48x48'],
            fullName: data.displayName,
            groups: data.groups.items,
            roles: data.applicationRoles.items,
            email: data.emailAddress
          });
        },
        error: function () {
          deferred.reject();
        }
      });
    }
  });

  // Registering provider for user item type
  api.registerItemDetailsProvider('com.almworks.jira.structure:type-user', UserDetailsProvider);

})(window);