/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.sbcolumn;

import com.almworks.jira.structure.api.attribute.CoreAttributeSpecs;
import com.almworks.jira.structure.api.error.StructureProviderException;
import com.almworks.jira.structure.api.export.ExportCell;
import com.almworks.jira.structure.api.export.ExportColumn;
import com.almworks.jira.structure.api.export.ExportFormat;
import com.almworks.jira.structure.api.export.ExportRenderContext;
import com.almworks.jira.structure.api.export.ExportRenderer;
import com.almworks.jira.structure.api.export.ExportRendererProvider;
import com.almworks.jira.structure.api.export.ExportRequestContext;
import com.almworks.jira.structure.api.export.ExportRow;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.almworks.jira.structure.api.view.ViewSpecification;
import com.almworks.jira.structure.sbcolumn.StatusBarAttributeProvider;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarRendererProvider
implements ExportRendererProvider {
    static final String COLUMN_KEY = "com.almworks.jira.structure.sbcolumn";
    private final StatusManager myStatusManager;

    public StatusBarRendererProvider(StatusManager statusManager) {
        this.myStatusManager = statusManager;
    }

    @Nullable
    public ExportRenderer getColumnRenderer(@NotNull ExportFormat exportFormat, @NotNull ViewSpecification.Column columnSpec, @NotNull ExportRequestContext context) throws StructureProviderException {
        Map parameters;
        List statuses;
        if (!COLUMN_KEY.equals(columnSpec.getKey())) {
            return null;
        }
        String name = columnSpec.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = context.getI18n().getText("sbcolumn.name", new Object[0]);
        }
        if ((statuses = StructureUtil.getMultiParameter((Map)(parameters = columnSpec.getParameters()), (String)"statuses")).isEmpty()) {
            throw new StructureProviderException("statuses parameter is required");
        }
        boolean includeItself = StructureUtil.getSingleParameterBoolean((Map)parameters, (String)"includeItself");
        return new StatusBarRenderer(name, statuses, includeItself);
    }

    private class StatusBarRenderer
    implements ExportRenderer {
        private final String myName;
        private final List<String> myStatuses;
        private final boolean myIncludeItself;
        private final Map<String, String> myStatusNames = new HashMap<String, String>();

        public StatusBarRenderer(String name, List<String> statuses, boolean includeItself) {
            this.myName = name;
            this.myStatuses = statuses;
            this.myIncludeItself = includeItself;
        }

        public void prepare(@NotNull ExportRequestContext context) {
            context.requireAttribute(StatusBarAttributeProvider.STATUS_BAR);
            context.requireAttribute(CoreAttributeSpecs.STATUS);
        }

        public void configureColumn(@NotNull ExportColumn column, @NotNull ExportRenderContext context) {
            column.getHeaderCell().setText(this.myName);
        }

        public void renderCell(@NotNull ExportCell cell, @NotNull ExportRow row, @NotNull ExportRenderContext context) {
            Map map = (Map)row.get(StatusBarAttributeProvider.STATUS_BAR);
            if (map == null || map.isEmpty()) {
                return;
            }
            String itself = null;
            if (!this.myIncludeItself) {
                if (row.isLeaf()) {
                    return;
                }
                Status status = (Status)row.get(CoreAttributeSpecs.STATUS);
                if (status != null) {
                    itself = status.getId();
                }
            }
            StringBuilder sb = new StringBuilder();
            for (String id : this.myStatuses) {
                String name;
                Integer count;
                if (StringUtils.isEmpty((String)id) || (count = (Integer)map.get(id)) == null || StringUtils.isEmpty((String)(name = this.getStatusName(id)))) continue;
                if (id.equals(itself)) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count - 1);
                }
                if (count <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(count).append(' ').append(name);
            }
            if (sb.length() > 0) {
                cell.setText(sb.toString());
            }
        }

        private String getStatusName(String id) {
            Status status;
            String name = this.myStatusNames.get(id);
            if (name == null && (status = StatusBarRendererProvider.this.myStatusManager.getStatus(id)) != null) {
                name = status.getName();
                this.myStatusNames.put(id, name);
            }
            return name;
        }
    }
}

