/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.sbcolumn;

import com.almworks.jira.structure.api.attribute.CoreAttributeSpecs;
import com.almworks.jira.structure.api.error.StructureProviderException;
import com.almworks.jira.structure.api.export.ExportContextKeys;
import com.almworks.jira.structure.api.export.ExportFormat;
import com.almworks.jira.structure.api.export.ExportRenderContext;
import com.almworks.jira.structure.api.export.ExportRenderer;
import com.almworks.jira.structure.api.export.ExportRendererProvider;
import com.almworks.jira.structure.api.export.ExportRequestContext;
import com.almworks.jira.structure.api.export.ExportRow;
import com.almworks.jira.structure.api.export.excel.ExcelCell;
import com.almworks.jira.structure.api.export.excel.ExcelColumn;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.almworks.jira.structure.api.view.ViewSpecification;
import com.almworks.jira.structure.sbcolumn.StatusBarAttributeProvider;
import com.atlassian.jira.issue.status.Status;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarExcelProvider
implements ExportRendererProvider<ExcelCell, ExcelColumn> {
    private static final int BAR_LENGTH = 30;
    private static final String BAR_STRING = StringUtils.repeat((String)"|", (int)30);

    @Nullable
    public ExportRenderer<ExcelCell, ExcelColumn> getColumnRenderer(@NotNull ExportFormat exportFormat, @NotNull ViewSpecification.Column columnSpec, @NotNull ExportRequestContext context) throws StructureProviderException {
        Map parameters;
        List statuses;
        if (exportFormat != ExportFormat.MS_EXCEL || !"com.almworks.jira.structure.sbcolumn".equals(columnSpec.getKey())) {
            return null;
        }
        String name = columnSpec.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = context.getI18n().getText("sbcolumn.name", new Object[0]);
        }
        if ((statuses = StructureUtil.getMultiParameter((Map)(parameters = columnSpec.getParameters()), (String)"statuses")).isEmpty()) {
            throw new StructureProviderException("statuses parameter is required");
        }
        List colors = StructureUtil.getMultiParameter((Map)parameters, (String)"colors");
        if (colors.isEmpty()) {
            throw new StructureProviderException("colors parameter is required");
        }
        if (statuses.size() != colors.size()) {
            throw new StructureProviderException("colors.length must match statuses.length");
        }
        boolean includeItself = StructureUtil.getSingleParameterBoolean((Map)parameters, (String)"includeItself");
        return new StatusBarRenderer(name, statuses, colors, includeItself);
    }

    private static class RGB {
        static final RGB BLACK = new RGB(0, 0, 0);
        final byte red;
        final byte green;
        final byte blue;

        public RGB(int red, int green, int blue) {
            this.red = (byte)red;
            this.green = (byte)green;
            this.blue = (byte)blue;
        }

        static RGB fromHex(String hex) {
            try {
                int rgb = Integer.decode(hex);
                return new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            }
            catch (NumberFormatException e) {
                return BLACK;
            }
        }
    }

    private static class Palette {
        private final HSSFWorkbook myWorkbook;
        private final HSSFPalette myPalette;
        private final Map<String, Short> myColors = new HashMap<String, Short>();
        private final Map<String, Short> myFonts = new HashMap<String, Short>();
        private final Map<String, CellStyle> myStyles = new HashMap<String, CellStyle>();

        public Palette(HSSFWorkbook workbook) {
            this.myWorkbook = workbook;
            this.myPalette = workbook.getCustomPalette();
        }

        private short getColorIndex(String hex) {
            Short index = this.myColors.get(hex);
            if (index == null) {
                RGB rgb = RGB.fromHex(hex);
                HSSFColor color = this.getHSSFColor(rgb);
                index = color.getIndex();
                this.myColors.put(hex, index);
            }
            return index;
        }

        private HSSFColor getHSSFColor(RGB rgb) {
            HSSFColor color = this.myPalette.findColor(rgb.red, rgb.green, rgb.blue);
            if (color == null && (color = this.myPalette.findSimilarColor(rgb.red, rgb.green, rgb.blue)) == null) {
                try {
                    color = this.myPalette.addColor(rgb.red, rgb.green, rgb.blue);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return color != null ? color : this.getHSSFColor(RGB.BLACK);
        }

        private short getFontIndex(String hex) {
            Short index = this.myFonts.get(hex);
            if (index == null) {
                HSSFFont font = this.myWorkbook.createFont();
                font.setColor(this.getColorIndex(hex));
                index = font.getIndex();
                this.myFonts.put(hex, index);
            }
            return index;
        }

        private HSSFFont getFont(String hex) {
            return this.myWorkbook.getFontAt(this.getFontIndex(hex));
        }

        public void setCellStyle(Cell cell, String hex) {
            CellStyle style = this.myStyles.get(hex);
            if (style == null) {
                style = this.myWorkbook.createCellStyle();
                style.cloneStyleFrom(cell.getCellStyle());
                style.setFont((Font)this.getFont(hex));
                this.myStyles.put(hex, style);
            }
            cell.setCellStyle(style);
        }

        public void applyFont(RichTextString string, int from, int to, String hex) {
            string.applyFont(from, to, this.getFontIndex(hex));
        }
    }

    private static class StatusBarRenderer
    implements ExportRenderer<ExcelCell, ExcelColumn> {
        private final String myName;
        private final List<String> myStatuses;
        private final List<String> myColors;
        private final Map<String, Integer> myExclude;
        private final Map<String, Integer> myTempMap = new HashMap<String, Integer>();

        public StatusBarRenderer(String name, List<String> statuses, List<String> colors, boolean includeItself) {
            this.myName = name;
            this.myStatuses = statuses;
            this.myColors = colors;
            this.myExclude = includeItself ? null : new HashMap();
        }

        public void prepare(@NotNull ExportRequestContext context) {
            context.requireAttribute(StatusBarAttributeProvider.STATUS_BAR);
            context.requireAttribute(CoreAttributeSpecs.STATUS);
        }

        public void configureColumn(@NotNull ExcelColumn column, @NotNull ExportRenderContext context) {
            ((ExcelCell)column.getHeaderCell()).setText(this.myName);
        }

        public void renderCell(@NotNull ExcelCell excelCell, @NotNull ExportRow row, @NotNull ExportRenderContext context) {
            Map<String, Integer> values = (Map<String, Integer>)row.get(StatusBarAttributeProvider.STATUS_BAR);
            if (values == null || values.isEmpty()) {
                return;
            }
            if (this.myExclude != null) {
                if (row.isLeaf()) {
                    return;
                }
                values = this.excludeItself(values, (Status)row.get(CoreAttributeSpecs.STATUS));
            }
            values = this.distribute(values, 30);
            this.renderStatusBar(values, context);
        }

        private Map<String, Integer> excludeItself(Map<String, Integer> values, Status selfStatus) {
            if (selfStatus == null) {
                return values;
            }
            this.myExclude.clear();
            this.myExclude.putAll(values);
            String status = selfStatus.getId();
            Integer value = this.myExclude.get(status);
            if (value != null && value > 0) {
                this.myExclude.put(status, value - 1);
            }
            return this.myExclude;
        }

        private Map<String, Integer> distribute(Map<String, Integer> values, int amount) {
            float total = 0.0f;
            int max = 0;
            for (String key : this.myStatuses) {
                Integer value = values.get(key);
                if (value == null || value <= 0) continue;
                total += (float)value.intValue();
                max = Math.max(max, value);
            }
            if (total == 0.0f) {
                return Collections.emptyMap();
            }
            Map<String, Integer> result = this.myTempMap;
            result.clear();
            int remaining = amount;
            for (String key : this.myStatuses) {
                Integer value = values.get(key);
                if (value == null || value <= 0 || value >= max) continue;
                int p = Math.round(value.floatValue() / total * (float)amount);
                result.put(key, p);
                remaining -= p;
            }
            String last = null;
            for (String key : this.myStatuses) {
                Integer value = values.get(key);
                if (value == null || value != max) continue;
                int p = Math.min(remaining, Math.round(value.floatValue() / total * (float)amount));
                result.put(key, p);
                remaining -= p;
                last = key;
            }
            if (remaining > 0) {
                result.put(last, result.get(last) + remaining);
            }
            return result;
        }

        private void renderStatusBar(Map<String, Integer> values, ExportRenderContext context) {
            Palette palette = (Palette)context.getObject(Palette.class);
            if (palette == null) {
                HSSFWorkbook workbook = (HSSFWorkbook)context.getObject((Object)ExportContextKeys.Excel.POI_WORKBOOK);
                palette = new Palette(workbook);
                context.putObject(Palette.class, (Object)palette);
            }
            Cell cell = (Cell)context.getObject((Object)ExportContextKeys.Excel.POI_CELL);
            CreationHelper helper = (CreationHelper)context.getObject((Object)ExportContextKeys.Excel.POI_HELPER);
            RichTextString bar = helper.createRichTextString(BAR_STRING);
            int start = 0;
            for (int i = 0; i < this.myStatuses.size(); ++i) {
                Integer value = values.get(this.myStatuses.get(i));
                if (value == null || value <= 0) continue;
                if (start == 0) {
                    palette.setCellStyle(cell, this.myColors.get(i));
                } else {
                    palette.applyFont(bar, start, start + value, this.myColors.get(i));
                }
                start += value.intValue();
            }
            cell.setCellValue(bar);
        }
    }
}

