/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.sbcolumn;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.CoreAttributeSpecs;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoaderProvider;
import com.almworks.jira.structure.api.attribute.loader.AttributeProviderContext;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractNaiveDistinctAggregateLoader;
import com.atlassian.jira.issue.status.Status;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarAttributeProvider
implements AttributeLoaderProvider {
    public static final AttributeSpec<Map<String, Integer>> STATUS_BAR = new AttributeSpec("com.almworks.statusbar", ValueFormat.JSON_OBJECT);
    private final AttributeLoader<Map<String, Integer>> LOADER = new StatusBarLoader();

    @Nullable
    public AttributeLoader<?> createAttributeLoader(@NotNull AttributeSpec<?> attributeSpec, @NotNull AttributeProviderContext context) {
        if (STATUS_BAR.getId().equals(attributeSpec.getId())) {
            return this.LOADER;
        }
        return null;
    }

    private static class StatusBarLoader
    extends AbstractNaiveDistinctAggregateLoader<Map<String, Integer>> {
        public StatusBarLoader() {
            super(STATUS_BAR);
        }

        protected Map<String, Integer> getRowValue(RowAttributeContext context) {
            Status value = (Status)context.getDependencyValue(CoreAttributeSpecs.STATUS);
            return value == null ? null : Collections.singletonMap(value.getId(), 1);
        }

        protected Map<String, Integer> combine(Collection<Map<String, Integer>> values, AggregateAttributeContext context) {
            HashMap<String, Integer> r = new HashMap<String, Integer>();
            for (Map<String, Integer> map : values) {
                if (map == null) continue;
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    Integer count = r.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    r.put(e.getKey(), count + e.getValue());
                }
            }
            return r;
        }

        @NotNull
        public Set<AttributeSpec<?>> getAttributeDependencies() {
            return Collections.singleton(CoreAttributeSpecs.STATUS);
        }
    }
}

