/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ZipUtils {
    public static final String ZIP_SUFFIX = ".zip";
    private final Logger logger = Logger.getLogger(ZipUtils.class);

    public boolean isZip(File inputFile) {
        return inputFile.getName().endsWith(ZIP_SUFFIX);
    }

    public void zip(File sourceDirectory, File zipFile) {
        this.logger.info((Object)String.format("Zipping %s", zipFile.getName()));
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            File[] files = sourceDirectory.listFiles();
            if (files == null) {
                throw new RuntimeException(String.format("Failed to zip. Source directory %s is invalid", sourceDirectory.getName()));
            }
            for (File fileToZip : files) {
                int length;
                FileInputStream fis = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
            }
            zipOut.close();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to zip %s", sourceDirectory), e);
        }
        this.logger.info((Object)"Zipping completed!");
    }

    public void unzip(File zipFile, File destinationDirectory) {
        this.logger.info((Object)String.format("Unzipping %s", zipFile.getName()));
        try {
            ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile.toPath(), new OpenOption[0]));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                this.createZipEntryFile(zipEntry, destinationDirectory, zis);
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to unzip %s", zipFile), e);
        }
        this.logger.info((Object)"Unzipping completed!");
    }

    private void createZipEntryFile(ZipEntry zipEntry, File destinationDirectory, ZipInputStream zis) throws IOException {
        if (!destinationDirectory.exists() && !destinationDirectory.mkdir()) {
            throw new IOException("Failed to create unzip target zip: " + destinationDirectory);
        }
        File destinationFile = new File(destinationDirectory, zipEntry.getName());
        if (!destinationFile.getCanonicalPath().startsWith(destinationDirectory.getCanonicalPath() + File.separator)) {
            throw new IOException("Zip entry is outside of the target dir: " + zipEntry.getName());
        }
        this.writeFileContent(destinationFile, (InputStream)zis);
    }

    private void writeFileContent(File file, InputStream is) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(file);
        while ((len = is.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
        fos.close();
    }
}

