/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.tempo.anonymizer.model.Table;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import org.jdom2.Namespace;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigurationService {
    public static final String RESERVED_WORD_DEFAULT = "DEFAULT";
    public static final String RESERVED_WORD_XML_NULL = "nil";
    public static final Namespace RESERVED_WORD_XML_NULL_NAMESPACE = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace NAMESPACE = Namespace.getNamespace((String)"http://www.atlassian.com/ao");
    public static final String ACTIVEOBJECTS_XML = "activeobjects.xml";
    public static final String ANON_PREFIX = "anon-";
    public static final File UNZIP_DEST_DIR = new File("unzip-temp");
    public final ClassLoader classLoader = this.getClass().getClassLoader();
    public final InputStream DEFAULT_TABLES_CONFIG_STREAM = this.classLoader.getResourceAsStream("tables.json");

    public List<Table> getTables() {
        return this.getTables(this.DEFAULT_TABLES_CONFIG_STREAM);
    }

    public List<Table> getTables(InputStream configFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (List)mapper.readValue(configFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load configuration file: %s", configFile), e);
        }
    }

    @Bean
    public Random random() {
        return new Random();
    }
}

