/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import io.tempo.anonymizer.AnonymizerMapper;
import io.tempo.anonymizer.ConfigurationService;
import io.tempo.anonymizer.model.ColumnRule;
import io.tempo.anonymizer.model.CustomFieldTable;
import io.tempo.anonymizer.model.CustomFieldType;
import io.tempo.anonymizer.model.Table;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AnonymizerService {
    private final Logger logger = Logger.getLogger(AnonymizerService.class);
    private final AnonymizerMapper anonymizerMapper;

    @Autowired
    public AnonymizerService(AnonymizerMapper anonymizerMapper) {
        this.anonymizerMapper = anonymizerMapper;
    }

    private static Document getDocument(File sourceFile) {
        Document document;
        try {
            document = new SAXBuilder().build(sourceFile);
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException(String.format("Failed to read XML file %s", sourceFile), e);
        }
        return document;
    }

    private static void writeDocument(File destinationFile, Document document) {
        try {
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.output(document, Files.newOutputStream(destinationFile.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to write XML file %s", destinationFile), e);
        }
    }

    private static List<String> getAllTableNames(List<Table> tables) {
        return tables.stream().map(Table::getTableName).collect(Collectors.toList());
    }

    private static Map<String, Table> getTablesWithColumnRules(List<Table> tables) {
        return tables.stream().filter(t -> !CollectionUtils.isEmpty((Collection)t.getColumnRules())).collect(Collectors.toMap(Table::getTableName, table -> table));
    }

    private static Map<String, Table> getTablesWithActions(List<Table> tables) {
        return tables.stream().filter(t -> !CollectionUtils.isEmpty((Collection)t.getTableActions())).collect(Collectors.toMap(Table::getTableName, table -> table));
    }

    public void anonymize(File sourceFile, File destinationFile, List<Table> tables) {
        Document document = AnonymizerService.getDocument((File)sourceFile);
        Element rootElement = document.getRootElement();
        this.removeIrrelevantTables(tables, rootElement);
        this.anonymizeRelevantTables(tables, rootElement);
        AnonymizerService.writeDocument((File)destinationFile, (Document)document);
    }

    private void removeIrrelevantTables(List<Table> tables, Element rootElement) {
        this.logger.info((Object)"Cleaning irrelevant tables...");
        List allTableNames = AnonymizerService.getAllTableNames(tables);
        ArrayList<Element> toDelete = new ArrayList<Element>();
        for (Element element : rootElement.getChildren()) {
            if ("table".equals(element.getName()) && !allTableNames.contains(this.getNameValue(element))) {
                toDelete.add(element);
                continue;
            }
            if (!"data".equals(element.getName()) || allTableNames.contains(this.getTableNameValue(element))) continue;
            toDelete.add(element);
        }
        for (Element element : toDelete) {
            element.getParent().removeContent((Content)element);
        }
        this.logger.info((Object)"Cleaning completed!");
    }

    private void anonymizeRelevantTables(List<Table> tables, Element rootElement) {
        this.logger.info((Object)"Anonymizing Tables...");
        Map tablesWithActions = AnonymizerService.getTablesWithActions(tables);
        Map tablesWithColumnRules = AnonymizerService.getTablesWithColumnRules(tables);
        for (Element data : rootElement.getChildren("data", ConfigurationService.NAMESPACE)) {
            String tableName = this.getTableNameValue(data);
            if (tablesWithActions.containsKey(tableName)) {
                this.applyTableActions(tablesWithActions, data, tableName);
            }
            if (!tablesWithColumnRules.containsKey(tableName)) continue;
            this.applyColumnRules(tablesWithColumnRules, data, tableName, rootElement);
        }
        this.logger.info((Object)"Anonymizing completed!");
    }

    private void applyColumnRules(Map<String, Table> tablesWithColumnRules, Element data, String tableName, Element rootElement) {
        Table table = tablesWithColumnRules.get(tableName);
        Map indexRuleTypeMap = this.createIndexColumnRuleTypeMap(data, table);
        List customFieldTableRowElements = table.getCustomFieldTable() != null ? this.getCustomFieldTableRows(table, rootElement) : new ArrayList();
        for (Element row : data.getChildren("row", ConfigurationService.NAMESPACE)) {
            List columnValues = row.getChildren();
            CustomFieldType customFieldType = this.getCustomFieldType(customFieldTableRowElements, table, row);
            indexRuleTypeMap.forEach((index, columnRule) -> this.anonymizerMapper.doAnonymize((Element)columnValues.get((int)index), columnRule, customFieldType));
        }
    }

    private void applyTableActions(Map<String, Table> tablesWithActions, Element data, String tableName) {
        tablesWithActions.get(tableName).getTableActions().forEach(action -> this.anonymizerMapper.doAnonymize(data, action));
    }

    private Map<Integer, ColumnRule> createIndexColumnRuleTypeMap(Element data, Table table) {
        HashMap<Integer, ColumnRule> indexRuleMap = new HashMap<Integer, ColumnRule>();
        Map<String, ColumnRule> columnsWithRules = table.getColumnRules().stream().collect(Collectors.toMap(ColumnRule::getColumnName, c -> c));
        List columns = data.getChildren("column", ConfigurationService.NAMESPACE);
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = this.getNameValue((Element)columns.get(i));
            if (!columnsWithRules.containsKey(columnName)) continue;
            indexRuleMap.put(i, columnsWithRules.get(columnName));
        }
        return indexRuleMap;
    }

    private String getNameValue(Element element) {
        return element.getAttribute("name").getValue();
    }

    private String getTableNameValue(Element element) {
        return element.getAttribute("tableName").getValue();
    }

    private List<Element> getCustomFieldTableRows(Table table, Element rootElement) {
        CustomFieldTable customFieldTable = table.getCustomFieldTable();
        return rootElement.getChildren("data", ConfigurationService.NAMESPACE).stream().filter(element -> element.getAttribute("tableName").getValue().equals(customFieldTable.getName())).findFirst().orElseThrow(() -> new RuntimeException(String.format("Failed to find custom field table %s", customFieldTable.getName()))).getChildren("row", ConfigurationService.NAMESPACE);
    }

    private CustomFieldType getCustomFieldType(List<Element> customFieldTableRowElements, Table table, Element row) {
        for (Element customFieldTableRow : customFieldTableRowElements) {
            String rowCustomFieldReferenceId = ((Element)row.getChildren().get(table.getCustomFieldReferenceIdPosition())).getValue();
            String customFieldTableRowId = ((Element)customFieldTableRow.getChildren().get(table.getCustomFieldTable().getIdFieldPosition())).getValue();
            if (!customFieldTableRowId.equals(rowCustomFieldReferenceId)) continue;
            return CustomFieldType.valueOf((String)((Element)customFieldTableRow.getChildren().get(table.getCustomFieldTable().getTypeFieldPosition())).getValue());
        }
        return null;
    }
}

