/*
 * Decompiled with CFR 0.152.
 */
package io.tempo.anonymizer;

import io.tempo.anonymizer.AnonymizerService;
import io.tempo.anonymizer.ConfigurationService;
import io.tempo.anonymizer.FileUtils;
import io.tempo.anonymizer.ZipUtils;
import java.io.File;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Component;

@ComponentScan
@Component
public class AnonymizerApplication {
    private final Logger logger = Logger.getLogger(AnonymizerApplication.class);
    private final AnonymizerService anonymizerService;
    private final ConfigurationService configurationService;
    private final ZipUtils zipUtils;
    private final FileUtils fileUtils;

    @Autowired
    public AnonymizerApplication(AnonymizerService anonymizerService, ConfigurationService configurationService, ZipUtils zipUtils, FileUtils fileUtils) {
        this.anonymizerService = anonymizerService;
        this.configurationService = configurationService;
        this.zipUtils = zipUtils;
        this.fileUtils = fileUtils;
    }

    public static void main(String[] args) {
        AnnotationConfigApplicationContext app = new AnnotationConfigApplicationContext(new Class[]{AnonymizerApplication.class});
        ((AnonymizerApplication)app.getBean(AnonymizerApplication.class)).run(args);
    }

    public void run(String[] args) {
        File inputFile;
        if (args.length != 1) {
            this.logger.warn((Object)"Please specify a zip or xml file");
            System.exit(0);
        }
        String inputFileName = args[0];
        File sourceXml = inputFile = new File(inputFileName);
        if (this.zipUtils.isZip(inputFile)) {
            this.fileUtils.delete(ConfigurationService.UNZIP_DEST_DIR);
            this.zipUtils.unzip(inputFile, ConfigurationService.UNZIP_DEST_DIR);
            sourceXml = new File(ConfigurationService.UNZIP_DEST_DIR, "activeobjects.xml");
        }
        File destinationXml = this.fileUtils.createPrefixed(sourceXml, "anon-");
        this.anonymizerService.anonymize(sourceXml, destinationXml, this.configurationService.getTables());
        if (this.zipUtils.isZip(inputFile)) {
            this.fileUtils.delete(sourceXml);
            this.fileUtils.rename(destinationXml, "activeobjects.xml");
            this.zipUtils.zip(ConfigurationService.UNZIP_DEST_DIR, this.fileUtils.createPrefixed(inputFile, "anon-"));
            this.fileUtils.delete(ConfigurationService.UNZIP_DEST_DIR);
        }
    }
}

